
import pandas as pd 
import os
import numpy as np
from scipy.stats import norm
import numpy as  np
import csv
import seaborn as sns

sns.set()


def get_stat(a):
    a= np.array(a)
    mean =  np.mean(a,axis=0)
    var = np.var(a,axis=0)
    return mean, var


def get_expectation(folder_prefix, saved_model_name,num_run):
    all_acc = []
    all_clean_loss = []
    all_adv_loss =[]
    all_acc_p =[]

    
    for i in range(num_run):
        filename = folder_prefix+ saved_model_name+'/dp_result_'+str(i)+'.csv'
 
        df = pd.read_csv(filename)  
        if i==0:
            epochs =[df.loc[i, 'epoch'] for i in range(df.shape[0])]
            epss =[df.loc[i, 'eps'] for i in range(df.shape[0])]
        acc=[df.loc[i, 'acc'] for i in range(df.shape[0])]
        clean_loss=[df.loc[i, 'clean_loss'] for i in range(df.shape[0])]
        adv_loss=[df.loc[i, 'adv_loss'] for i in range(df.shape[0])]
        acc_p=[df.loc[i, 'acc_p'] for i in range(df.shape[0])]

        all_acc.append(acc)
        all_clean_loss.append(clean_loss)
        all_adv_loss.append(adv_loss)
        all_acc_p.append(acc_p)

  
    acc_mean, acc_var = get_stat(all_acc)
    clean_loss_mean, clean_loss_var = get_stat(all_clean_loss)
    adv_loss_mean, adv_loss_var = get_stat(all_adv_loss)
    acc_p_mean, acc_p_var = get_stat(all_acc_p)
   

    dp_csvFile=  open(folder_prefix+ saved_model_name+'/all_exp.csv', "w")
    dp_writer = csv.writer(dp_csvFile)
    dp_writer.writerow(["epoch",  "eps", 
                        "acc_mean", "acc_var", 
                        "clean_loss_mean", "clean_loss_var",
                        "adv_loss_mean", "adv_loss_var",
                        "acc_p_mean","acc_p_var"
                        ])
    data = []
    
    for i in range(len(epochs)):
        data.append(
                    [
                    epochs[i],epss[i],
                    round(acc_mean[i],6) , round(acc_var[i],6),
                    round(clean_loss_mean[i],6) , round(clean_loss_var[i],6),
                    round(adv_loss_mean[i],6) , round(adv_loss_var[i],6),
                    round(acc_p_mean[i],6), round(acc_p_var[i],6)
                    ]
                    )
    dp_writer.writerows(data)
    dp_csvFile.close()

    

if __name__ == '__main__':
   
    folder_prefix='root/folder/path/' 
   
    dirs = os.listdir(folder_prefix)   
    for file in dirs:
        if file!='.DS_Store':
            print(file)
            get_expectation(folder_prefix, file,100)



