
import pandas as pd 

import os
import numpy as np


import matplotlib.pyplot as plt
from scipy.stats import norm
import math
import numpy as  np

import seaborn as sns

sns.set()



def k_from_upper_bound (eps,  delta, barc, jb,tau):
    k = 1/eps * math.log( ( (math.exp(eps)-1) *jb* tau + barc * delta   )/((math.exp(eps)-1) *jb + barc * delta  ))
    return int(k)

def k_from_lower_bound (eps,  delta, barc, jb,tau):
   
    k = 1/eps * math.log( ( (math.exp(eps)-1) *jb* tau + barc * delta * tau  )/((math.exp(eps)-1) *jb + barc * delta * tau ))
   
    return k

def get_dp_result(folder_prefix, saved_model_name):
   
    
    filename = folder_prefix+ saved_model_name+'/all_exp.csv'
    print(filename)
    df = pd.read_csv(filename) 
    epochs = [df.loc[i, 'epoch'] for i in range(df.shape[0])]
    epss = [df.loc[i, 'eps'] for i in range(df.shape[0])]
    mean= [df.loc[i, 'adv_loss_mean'] for i in range(df.shape[0])]
    var=[df.loc[i, 'adv_loss_var'] for i in range(df.shape[0])]

   
    return epochs,epss,mean,var 


if __name__ == '__main__':
    insDP= False
    if insDP:
   
        noise=[5,8,10,13,20]
        epoch=10
        delta=1.0e-05
        barc = 0.5
    else:
        noise=[1.3,1.6,1.9,2.2,2.5]
        epoch=5
        delta=0.0029 
        barc = 0.5

    epoch_idx = epoch -1

    taus = [i*1.0/2 for i in range(2,200,1)]
    eps_list=[]
    jbs_list=[]
    fig = plt.figure()
    for i in range(len(noise)):
        if insDP:
            epochs,epss,jbs,var  = get_dp_result('path/to/noise'+str(noise[i]), '/adv0')
        else:
            epochs,epss,jbs,var  = get_dp_result('path/to/noise'+str(noise[i]), '/adv0')
        lowerbounds= [ k_from_lower_bound(epss[epoch_idx],delta,barc,jbs[epoch_idx],tau ) for tau in taus] 
        lab = '$\epsilon$ = {:.4f}'.format(epss[epoch_idx])
        plt.plot(taus, lowerbounds, label=lab  ,ls='--')
    
    plt.xlabel("$\\tau$", fontsize=22)
    if insDP==False:
        plt.ylabel('$k$', fontsize=22)
        title= "(a) MNIST"
    else:
        title= "(c) MNIST"

    plt.legend(prop={'size'   : 18})
    if insDP:
        outfile = "../plots/tau/mnist_insdp_k_tau_epoch"+str(epoch)
    else:
        outfile = "../plots/tau/mnist_userdp_k_tau_epoch"+str(epoch)
    plt.title(title, fontsize=22)
    
    plt.tight_layout()
    plt.savefig(outfile + ".pdf")
    plt.tight_layout()
    plt.savefig(outfile + ".png", dpi=300)
    plt.close()





        

