
# Datasets:
mnist and cifar will be automaticly download into the dir 
`./data`

# Run experiments: 
## 1. DPFL training under adversarial users/instances
- Train User-level DP models under different $k$ for certified attack cost:

```python
python main.py --params utils/mnist_params.yaml
python main.py --params utils/cifar_params.yaml
```
- Train User-level DP clean models for certified prediction:
```python
python main.py --params utils/mnist_params_ceracc.yaml
python main.py --params utils/cifar_params_ceracc.yaml
```
- Train Instance-level DP models under different $k$ for certified attack cost:
```python
python main_insdp.py --params utils/mnist_params_insdp.yaml
python main_insdp.py --params utils/cifar_params_insdp.yaml
```
- Train Instance-level DP clean models for certified prediction:
```python
python main_insdp.py --params utils/mnist_params_insdp_ceracc.yaml
python main_insdp.py --params utils/cifar_params_insdp_ceracc.yaml
```

Hyperparameters can be changed according to our experiments setups (see appendix A.3 for paramerters details) in those yaml files (`utils/mnist_params.yaml`,`utils/cifar_params.yaml`, ` utils/mnist_params_ceracc.yaml`, ` utils/cifar_params_ceracc.yaml`,` utils/mnist_params_insdp.yaml`,` utils/cifar_params_insdp.yaml`,` utils/mnist_params_insdp_ceracc.yaml`,` utils/cifar_params_insdp_ceracc.yaml`) to reproduce our experiments.

## 2. Robust Certification Evaluation - Certified Prediction

- Calculate the expected class confidence according to Monte-Carlo sampling
```python
python plots/cal_expectation.py
python plots/conf_est_mnist.py
python plots/conf_est_cifar.py
```
- Draw figures of certified accuracy
```python
python certify.py
```

## 3. Robust Certification Evaluation - Certified Attack Cost

- Calculate the expected cost according to Monte-Carlo sampling
```python
python plots/cal_expectation.py
```
- Draw figures of certified attack cost under different $k$ 
```python
python plots/ana_k.py
python plots/ana_k_cifar.py
```
- Draw figures of certified attack cost under different $\epsilon$
```python
python plots/ana_eps.py
python plots/ana_eps_cifar.py
```
- Draw figures of upper bound on $k$ under different $\tau$
```python
python plots/ana_bound.py
python plots/ana_bound_cifar.py
```

