# Experiment for realative error of RFF

In this experiment, we evaluate the empirical relative error of kernel distance defined in Section 6 of our paper.

## Evaluation

### Parameters & Data

We set the parameter in the code before evaluation.

First we generate a synthesized dataset X which consists of $N = 100$ points with $d = 60$ dimensions generated from a Gaussian distribution. 

### Measure

For each target dimension $D \in \{16, 30, 48, 60, 76, 90\}$, evaluate its average error over $T = 20$ times.

We have 2 files evaluating relative error of *RFF* and *New-Lap* respectively, 
and compare it with *SVD* and *JL*.

### Usage

To evaluate the empirical relative error for Gaussian kernel $K(x) = exp(-0.5 \|x\|_2^2)$, run

```bash
python3 ./rff-experiment.py
```

to evaluate the empirical relative error for Laplacian kernel $K(x) = exp(-0.5 \|x\|)$ , run 

```bash
python3 ./lap-experiment.py
```

It will draw the dimension-error tradeoff curve.
