from sklearn.neighbors import NearestNeighbors
import numpy as np
from sklearn.preprocessing import MinMaxScaler

class NovRej:
    
    def __init__(self, k = 10, seed = 9, contamination = 0.1):
        self.seed = seed
        self.k = k
        self.contamination = contamination
        self.threshold = 0.5
    
    def set_rejection_rate(self, contamination):
        self.contamination = contamination
        self.threshold = np.quantile(self.train_scores, 1-self.contamination)

    def fit(self, Z, y):
        self.scaler = MinMaxScaler()
        Znorm = self.scaler.fit_transform(Z)
        
        self.rejector = NearestNeighbors(n_neighbors=self.k+1)
        self.rejector.fit(Znorm)
        
        scores, _ = self.rejector.kneighbors(Znorm)
        self.train_scores = scores[:, self.k]
        self.threshold = np.quantile(self.train_scores , 1-self.contamination)
        
        
    def score(self, Z):
        Znorm = self.scaler.transform(Z)
        scores, _ = self.rejector.kneighbors(Znorm)
        return scores[:, self.k-1]
        
    def reject(self, Z):
        return np.where(self.score(Z) >= self.threshold, 1, 0)
