## Dependencies

This folder requires the following python packages to be used:
- [Python 3](http://www.python.org)
- [Numpy](http://www.numpy.org)
- [Scipy](http://www.scipy.org)
- [Pandas](https://pandas.pydata.org/)
- [Matplot](https://matplotlib.org)
- [sklearn](https://scikit-learn.org/stable/)
- [pytorch](https://pytorch.org)
- [shap] (https://shap.readthedocs.io/en/latest/)
- [transformers] (https://pypi.org/project/transformers/)


## Datasets

- https://archive.ics.uci.edu/datasets?skip=70&take=10&sort=desc&orderBy=NumHits&search= (benchmark datasets)
- ../data (User study data)

## Note

- ULER.py is the method presented in the paper
- RandomRejection.py, PredictionAmbiguity.py, NoveltyRejection.py, StabilityRejection.py, FaithfulnessRejection.py, ComplexityRejection.py are the baselines used for the comparison. *Please ask to the corresponding authors for PASTA's code*.
- ULER_YZ.py, ULER_XZ.py, ULER_XYZ.py are the variants of method used in Q2
- Q1_experiment.py, Q1_experiment_rr.py, Q2_experiment.py, Q3_experiment.py, Q3_experiment_rr.py are the files used to run the experiments. Specifically, the files ending with *rr.py are the experiments where the number of accepted and rejected low-quality explanations is computed when varying the rejection rate. While the others compute the AUROC.
- preprocessing.py contains some utility function for preprocessing the data, etc.
- APP_*.py are the files used to run the experiments in the Appendix
- compute_shaps.py is the file used to generate the explanations
- compute_stability.py is the file used to generate the explanations needed to compute the stability of an explanation
- compute_faithfulness.py is the file used to compute the faithfulness of an explanation
- generate_llm_labels.py is the file used to generate the explanation quality labels with the LLM
- prompt.py contains the prompt to generate the LLM labels
- LICENSE is the license file for the data