import numpy as np
import pandas as pd

class RandRej:
    
    def __init__(self, seed=9, contamination=0.1):
        self.seed = seed
        self.contamination = contamination
        self.threshold = 1 - self.contamination
        
    def fit(self, Z):
        pass
    
    def set_rejection_rate(self, rr):
        self.contamination = rr
        self.threshold = 1 - self.contamination
    
    def reject(self, Z):
        return np.where(self.score(Z) > self.threshold, 1, 0)
    
    def score(self, Z):
        rej_scores = np.zeros(Z.shape[0])
        np.random.seed(self.seed)
        for i in range(Z.shape[0]):
            rej_scores[i] = np.random.rand()
        return rej_scores