import numpy as np

def discrete_replicator(*, p0, fitness, T, return_fitness=False, termination_predicate=None):
    """
    Discrete replicator equation dynamics
    Taylor & Jonker, 1978, eq. (3)
    """
    p = np.array(p0)
    P = []
    F = []
    for t in range(T):
        P.append(p)
        f = fitness(p)+1
        F.append(f-1)
        p = (p*f)/(p@f)
        if (termination_predicate is not None) and termination_predicate(p):
            break
    if not return_fitness:
        return np.vstack(P)
    else:
        return np.vstack(P), np.vstack(F)