#!/bin/bash
PARTITION=Classification

gpu_id=$4
 

mode=$1 # global local 
backbone=$2 # Res12
dataset=$3 # miniImageNet tieredImageNet
n_shots=$5
optim_steps_online=$6
alpha=$7

exp_dir=metallm_exp/${dataset}/${mode}_${backbone}
result_dir=${exp_dir}/result
now=$(date +"%Y%m%d_%H%M%S")

CUDA_VISIBLE_DEVICES=${gpu_id} python train.py --is_test --mode $mode --backbone $backbone --dataset $dataset  --n_shots $n_shots  --optim_steps_online $optim_steps_online --alpha $alpha \
        # 2>&1 | tee ${result_dir}/test-$now.log  
