dataset="tldr"
model_config="gpt2"

while getopts 'c:d:' opt; do
  case "$opt" in
    c)
      model_config="$OPTARG"
      echo "Setting model config to '${model_config}'"
      ;;

    d)
      dataset="$OPTARG"
      echo "Setting the dataset to '${dataset}'"
      ;;

  esac
done

mv data ..

python run_sagemaker.py src/training/ppo.py -c $model_config -d f DATASET=$dataset ENSEMBLE_AGG_FN=mean ENSEMBLE_KL=uncertainty & 
python run_sagemaker.py src/training/ppo.py -c $model_config -d f DATASET=$dataset ENSEMBLE_AGG_FN=mean ENSEMBLE_KL=fixed &
python run_sagemaker.py src/training/ppo.py -c $model_config -d f DATASET=$dataset ENSEMBLE_AGG_FN=min ENSEMBLE_KL=fixed &
python run_sagemaker.py src/training/ppo.py -c $model_config -d f DATASET=$dataset N_ENSEMBLES=1 &

sleep 5
mv ../data .
wait
