import torch


class AdaptiveUncertaintyKLController:
    def __init__(self, kl_coef: float = 0.05, prior_variance = None):
        self.value = kl_coef
        self.kl_coef = kl_coef
        self.prior_variance = prior_variance

    def update(self, *args, **kwargs):
        pass

    def value_uncertainty(self, reward_vars):
        if self.prior_variance is None:
            return torch.ones_like(reward_vars) * self.kl_coef
        
        result = reward_vars / self.prior_variance * self.kl_coef
        self.value = result.mean().item()
        return result
