# Uploads/download the training data to the S3 bucket
import argparse

import os
from dotenv import load_dotenv
from s3fs import S3FileSystem

parser = argparse.ArgumentParser()
parser.add_argument(
    "action", type=str, default="download", choices=["upload", "download"], 
    help="Specify whether you want to upload to or download from S3"
)
parser.add_argument(
    "directory", type=str, default="models", 
    help="Which directory to sync. It will be copied to the same location. You can also specify sub-directories, e.g. models/sft_models/gpt2-xl."
)
args = parser.parse_args()

load_dotenv()
bucket_name = os.getenv("S3_BUCKET")
s3fs = S3FileSystem() # Specify the correct region, e.g., "eu-west-1" if not set by default

if args.action == "upload":
    s3fs.upload(args.directory, f"s3://{bucket_name}/{os.path.dirname(args.directory)}/", recursive=True)

elif args.action == "download":
    s3fs.download(f"s3://{bucket_name}/{args.directory}/", args.directory, recursive=True)
