import tensorflow as tf
import tensorflow_datasets as tfds

# Load the builder
builder = tfds.builder_from_directory("/media/chief/data/Kubric-Datasets/movi-a/256x256/1.0.0")

# Print the names of the available splits
splits = builder.info.splits.keys()
print(f"Available splits: {splits}")

# Inspect each split
for split in splits:
    print(f"\nInspecting split: {split}")
    
    ds = builder.as_dataset(split=split)
    
    # Iterate over the dataset
    for i, example in enumerate(ds):
        print(f"\nExample #{i}")
        for key, value in example.items():
            # If the value is a dictionary, print the shapes of its items
            if isinstance(value, dict):
                print(f"  Key: {key}:")
                for subkey, subvalue in value.items():
                    # If the subvalue is a tensor, convert it to a numpy array and print its shape
                    if tf.is_tensor(subvalue):
                        subvalue_numpy = subvalue.numpy()
                        # if it is a byte string, decode it
                        if isinstance(subvalue_numpy, bytes):
                            subvalue_numpy = subvalue_numpy.decode("utf-8")
                            print(f"    Key: {subkey}, Value: {subvalue_numpy}, Type: string")
                        elif subvalue_numpy.ndim == 0:
                            print(f"    Key: {subkey}, Value: {subvalue_numpy}, Type: {subvalue_numpy.dtype}")
                        else:
                            print(f"    Key: {subkey}, Shape: {subvalue_numpy.shape}, Type: {subvalue_numpy.dtype}")
                    else:
                        print(f"    Key: {subkey}, Type: {type(subvalue)}")
            # If the value is a tensor, convert it to a numpy array and print its shape
            elif tf.is_tensor(value):
                value_numpy = value.numpy()
                if value_numpy.ndim == 0:
                    print(f"  Key: {key}, Value: {value_numpy}, Type: {value_numpy.dtype}")
                else:
                    print(f"  Key: {key}, Shape: {value_numpy.shape}, Type: {value_numpy.dtype}")
            else:
                print(f"Key: {key}, Type: {type(value)}")
