# EQUIVARIANT ENERGY-GUIDED SDE FOR INVERSE MOLECULAR DESIGN.

### Dependencies
```
conda create -c rdkit -n EEGSDE rdkit python=3.7
source activate EEGSDE
conda install pytorch==1.11.0 torchvision==0.12.0 torchaudio==0.11.0 cudatoolkit=11.3
pip install msgpack
conda install -c openbabel openbabel
pip install ase==3.19.0
pip install imageio
```
### Run EEGSDE to generate molecules with desired single quantum properties.
```
python run_EEGSDE_single_property.py --property mu --l 1.0 --exp_name eegsde_mu --generators_path outputs/cEDM_mu/generative_model_ema.npy \ 
--args_generators_path outputs/cEDM_mu/args.pickle --energy_path outputs/predict_mu/model_ema.npy \
--args_energy_path outputs/predict_mu/args.pickle --classifiers_path outputs/evaluate_mu/best_checkpoint.npy \
--args_classifiers_path outputs/evaluate_mu/args.pickle --batch_size 100 --iterations 100 --save False \
```
The ```property``` is which property to condition and is chosen from ```alpha/homo/lumo/gap/mu/Cv```. The ```l``` is the scale factor of the energy function. 
The ```generators_path``` and ```args_generators_path``` is the path of model and args with conditional EDM. 
The ```energy_path``` and ```args_energy_path``` is the path of model and args with property prediction model used in EEGSDE. 
The ```classifiers_path``` and ```args_classifiers_path``` is the path of model and args with the property prediction model for evaluation.
The results will be saved in ```outputs/exp_name```. The ```save``` is whether save the generated molecules.

### Run EEGSDE to generate molecules with desired multiple quantum properties.

```
python run_EEGSDE_multi_property.py --l1 1.5 --l2 1.5 --exp_name egsde_alpha_mu --generators_path outputs/cEDM_alpha_mu/generative_model_ema.npy \
--args_generators_path outputs/cEDM_alpha_mu/args.pickle --energy_path1 outputs/predict_alpha/model_ema.npy \
--args_energy_path1 outputs/predict_alpha/args.pickle --energy_path2 outputs/predict_mu/model_ema.npy \
--args_energy_path1 outputs/predict_mu/args.pickle --classifiers_path1 outputs/evaluate_alpha/best_checkpoint.npy \
--args_classifiers_path1 outputs/evaluate_alpha/args.pickle --classifiers_path2 outputs/evaluate_mu/best_checkpoint.npy \
--args_classifiers_path2 outputs/evaluate_mu/args.pickle  --batch_size 100 --iterations 100 --save False ```
```


### Run EEGSDE to generating molecules with target structures

```
python run_EEGSDE_fingerprint.py --l 0.5 --exp_name eegsde_qm9_fingerprint --generators_path outputs/cEDM_qm9_fingerprint/generative_model_ema.npy \
--args_generators_path outputs/cEDM_qm9_fingerprint/args.pickle --energy_path outputs/fingerprint_qm9_prediction/model_ema.npy \
--args_energy_path outputs/fingerprint_qm9_prediction/args.pickle --save False --batch_size 50 
```
The ```l``` is the scale factor of the energy function. 
The ```generators_path``` and ```args_generators_path``` is the path of model and args with conditional EDM. 
The ```energy_path``` and ```args_energy_path``` is the path of model and args with fingerprint prediction model used in EEGSDE. 
The results will be saved in ```outputs/exp_name```. The ```save``` is whether save the generated molecules.

