import pickle

import diffuser.utils as utils
from ml_logger import logger
import torch
from copy import deepcopy
import queue
import numpy as np
import os
import gym
import time
from config.locomotion_config import Config
from diffuser.utils.arrays import to_torch, to_np, to_device
from diffuser.datasets.d4rl import suppress_output

def evaluate(**deps):
    from ml_logger import logger, RUN
    from config.locomotion_config import Config

    RUN._update(deps)
    Config._update(deps)

    logger.remove('*.pkl')
    logger.remove("traceback.err")
    logger.log_params(Config=vars(Config), RUN=vars(RUN))

    Config.device = 'cuda'

    if Config.predict_epsilon:
        prefix = f'predict_epsilon_{Config.n_diffusion_steps}_1000000.0'
    else:
        prefix = f'predict_x0_{Config.n_diffusion_steps}_1000000.0'

    loadpath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    
    if Config.save_checkpoints:
        loadpath = os.path.join(loadpath, f'state_{self.step}.pt')
    else:
        loadpath = os.path.join(loadpath, 'state.pt')
    
    state_dict = torch.load(loadpath, map_location=Config.device)

    # Load configs
    torch.backends.cudnn.benchmark = True
    utils.set_seed(Config.seed)

    dataset_config = utils.Config(
        Config.loader,
        savepath='dataset_config.pkl',
        env=Config.dataset,
        horizon=Config.horizon,
        normalizer=Config.normalizer,
        preprocess_fns=Config.preprocess_fns,
        use_padding=Config.use_padding,
        max_path_length=Config.max_path_length,
        include_returns=Config.include_returns,
        returns_scale=Config.returns_scale,
    )

    # render_config = utils.Config(
    #     Config.renderer,
    #     savepath='render_config.pkl',
    #     env=Config.dataset,
    # )

    dataset = dataset_config()
    # renderer = render_config()

    observation_dim = dataset.observation_dim
    action_dim = dataset.action_dim

    if Config.diffusion == 'models.GaussianInvDynDiffusion':
        transition_dim = observation_dim
    else:
        transition_dim = observation_dim + action_dim

    model_config = utils.Config(
        Config.model,
        savepath='model_config.pkl',
        horizon=Config.horizon,
        transition_dim=transition_dim,
        cond_dim=observation_dim,
        dim_mults=Config.dim_mults,
        dim=Config.dim,
        returns_condition=Config.returns_condition,
        device=Config.device,
    )

    diffusion_config = utils.Config(
        Config.diffusion,
        savepath='diffusion_config.pkl',
        horizon=Config.horizon,
        observation_dim=observation_dim,
        action_dim=action_dim,
        n_timesteps=Config.n_diffusion_steps,
        loss_type=Config.loss_type,
        clip_denoised=Config.clip_denoised,
        predict_epsilon=Config.predict_epsilon,
        hidden_dim=Config.hidden_dim,
        ## loss weighting
        action_weight=Config.action_weight,
        loss_weights=Config.loss_weights,
        loss_discount=Config.loss_discount,
        returns_condition=Config.returns_condition,
        device=Config.device,
        condition_guidance_w=Config.condition_guidance_w,
    )

    trainer_config = utils.Config(
        utils.Trainer,
        savepath='trainer_config.pkl',
        train_batch_size=Config.batch_size,
        train_lr=Config.learning_rate,
        gradient_accumulate_every=Config.gradient_accumulate_every,
        ema_decay=Config.ema_decay,
        sample_freq=Config.sample_freq,
        save_freq=Config.save_freq,
        log_freq=Config.log_freq,
        label_freq=int(Config.n_train_steps // Config.n_saves),
        save_parallel=Config.save_parallel,
        bucket=Config.bucket,
        n_reference=Config.n_reference,
        train_device=Config.device,
    )

    model = model_config()
    diffusion = diffusion_config(model)
    # trainer = trainer_config(diffusion, dataset, renderer)
    trainer = trainer_config(diffusion, dataset)
    logger.print(utils.report_parameters(model), color='green')
    trainer.step = state_dict['step']
    trainer.model.load_state_dict(state_dict['model'])
    trainer.ema_model.load_state_dict(state_dict['ema'])

    num_eval = 10 #original 10
    num_steps = [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000]
    device = Config.device

    env_list = [gym.make(Config.dataset) for _ in range(num_eval)]
    dones = [0 for _ in range(num_eval)]
    episode_rewards = [0 for _ in range(num_eval)]

    assert trainer.ema_model.condition_guidance_w == Config.condition_guidance_w
    returns = to_device(Config.test_ret * torch.ones(num_eval, 1), device)

    t = 0
    obs_list = [env.reset()[None] for env in env_list]
    obs = np.concatenate(obs_list, axis=0)
    recorded_obs = [deepcopy(obs[:, None])]
    print(env_list[0]._max_episode_steps)

    reward_list = [[] for i in range(num_eval)]
    true_list = [[] for i in range(num_eval)]
    dist_list = [[] for i in range(num_eval)]

    total_returns = []
    q = queue.Queue(1)

    time_total = []
    # for k in range(10):
    #     step_idx = 0
    #     temp_time = []
    #     t = 0
    #     env_list = [gym.make(Config.dataset) for _ in range(num_eval)]
    #     dones = [0 for _ in range(num_eval)]
    #     episode_rewards = [0 for _ in range(num_eval)]
    #     start = torch.cuda.Event(enable_timing=True)
    #     end = torch.cuda.Event(enable_timing=True)
    #     obs_list = [env.reset()[None] for env in env_list]
    #     obs = np.concatenate(obs_list, axis=0)
    #     recorded_obs = [deepcopy(obs[:, None])]
    #     print(env_list[0]._max_episode_steps)
    #     last = 0
    #     start.record()
    #     # while step_idx < 1000:
    while sum(dones) < num_eval:
        conditions = {}
        obs = dataset.normalizer.normalize(obs, 'observations')
        if q.full():
            _ = q.get()
            q.put(obs)
        else:
            q.put(obs)
        for i, item in enumerate(q.queue):
            conditions.update({i: to_torch(item, device=device)})
        conditions_length = len(conditions)
        # conditions = {0: to_torch(obs, device=device)}
        # samples = trainer.ema_model.conditional_sample(conditions, returns=returns, horizon=Config.horizon + 20)
        samples = trainer.ema_model.conditional_sample(conditions, returns=returns, horizon=Config.horizon)
        samples, sample_reward = samples[:, :, :-1], samples[:, :, -1]
        obs_comb = torch.cat([samples[:, conditions_length - 1, :], samples[:, conditions_length, :]], dim=-1)      #TODO:increase window length
        obs_comb = obs_comb.reshape(-1, 2*observation_dim)
        action = trainer.ema_model.inv_model(obs_comb)

        samples = to_np(samples)
        action = to_np(action)

        reward_t = to_np(sample_reward[:, conditions_length - 1])
        reward_t_1 = to_np(sample_reward[:, 1])

        action = dataset.normalizer.unnormalize(action, 'actions')


        # if t == 0:
        #     normed_observations = samples[:, :, :]
        #     observations = dataset.normalizer.unnormalize(normed_observations, 'observations')
        #     savepath = os.path.join('images', 'sample-planned.png')
        #     renderer.composite(savepath, observations)

        obs_list = []
        for i in range(num_eval):
            this_obs, this_reward, this_done, _ = env_list[i].step(action[i])
            true_list[i].append(this_reward)
            reward_list[i].append(reward_t[i])
            # logger.print(f"R_t: {R_t[i] * 400 * 4}")    #for horizon 100 (100 * 3)
            # logger.print(f"R_t_1: {R_t_1[i] * 400 * 4}")
            # logger.print(f"this reward {this_reward}")
            # target_goal = env_list[i].target_goal
            # dist = np.exp(-np.linalg.norm(this_obs[:2] - target_goal))
            # dist_list[i].append(dist)
            obs_list.append(this_obs[None])
            # obs_list.append(dataset.normalizer.unnormalize(samples[i], "observations")[1][None])
            if this_done:
                if dones[i] == 1:
                    pass
                else:
                    dones[i] = 1
                    episode_rewards[i] += this_reward

                    total_returns.append(episode_rewards[i])
                    logger.print(f"Episode ({i}): {episode_rewards[i]}", color='green')
            else:
                if dones[i] == 1:
                    pass
                else:
                    episode_rewards[i] += this_reward
                    print("this reward", this_reward)

        obs = np.concatenate(obs_list, axis=0)
        recorded_obs.append(deepcopy(obs[:, None]))
        t += 1
        # step_idx += 1
        # print("==============================================")
        # print("step index", step_idx, "num", i)
        # print("==============================================")
        # if step_idx % 100 == 0:
        #     print("step_reached", step_idx)
        #     end.record()
        #     torch.cuda.synchronize()
        #     curr_time = start.elapsed_time(end)
        #     temp_time.append(curr_time - last)
        #     last = curr_time

    # print(f"complete traj {k}")
    reward_list = np.array(reward_list)
    true_list = np.array(true_list)
    # time_total.append(temp_time)
    for i in range(num_eval):
        print(f"true {i}", true_list[i])
        print(f"reward {i}", reward_list[i])

    print("MSE Error:", np.linalg.norm(true_list - reward_list) / (len(true_list) * len(true_list[0])))
        # print(f"distance {i}", dist_list[i])
    # with open("time.dat", "wb") as f:
    #     pickle.dump(time_total, f)
    recorded_obs = np.concatenate(recorded_obs, axis=1)
    savepath = os.path.join('images', f'sample-executed.png')
    # renderer.composite(savepath, recorded_obs)
    episode_rewards = np.array(episode_rewards)
    print("total returns", total_returns)
    #
    logger.print(f"average_ep_reward: {np.mean(episode_rewards)}, std_ep_reward: {np.std(episode_rewards)}", color='green')
    logger.log_metrics_summary({'average_ep_reward':np.mean(episode_rewards), 'std_ep_reward':np.std(episode_rewards)})
