import diffuser.utils as utils
from ml_logger import logger, RUN
import torch
from torch.distributions.multivariate_normal import MultivariateNormal
from copy import deepcopy
import numpy as np
import os
import gym
from diffuser.utils.timer import Timer
from config.locomotion_config import Config
from diffuser.utils.arrays import to_torch, to_np, to_device
from diffuser.datasets.d4rl import suppress_output
from diffuser.models.value_func_model import ValueMLP
from diffuser.models.forward_dynamics import ForwardDynamics
from diffuser.models.bisimulation_metric_model import BisimNet
from diffuser.datasets.sequence import CustomSequenceDataset
from collections import namedtuple
from diffuser.utils.trajectory import Trajectory
from scripts.create_trajectory import save_traj
from scripts.create_trajectory import train_val
import pickle


RewardBatch = namedtuple('Batch', 'trajectories conditions returns rewards')



def test(**deps):
    RUN._update(deps)
    Config._update(deps)

    logger.remove('*.pkl')
    logger.remove("traceback.err")
    logger.log_params(Config=vars(Config), RUN=vars(RUN))

    Config.device = 'cuda'
    if Config.predict_epsilon:
        prefix = f'predict_epsilon_{Config.n_diffusion_steps}_1000000.0'
    else:
        prefix = f'predict_x0_{Config.n_diffusion_steps}_1000000.0'

    loadpath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    next_loadpath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')

    if Config.save_checkpoints:
        loadpath = os.path.join(loadpath, f'state_{self.step}.pt')
    else:
        loadpath = os.path.join(loadpath, 'state.pt')

    if Config.save_checkpoints:
        next_loadpath = os.path.join(next_loadpath, f'state_{self.step}.pt')
    else:
        next_loadpath = os.path.join(next_loadpath, 'state_include_next.pt')

    state_dict = torch.load(loadpath, map_location=Config.device)
    # next_state_dict = torch.load(next_loadpath, map_location=Config.device)


    # Load configs
    torch.backends.cudnn.benchmark = True
    utils.set_seed(Config.seed)

    dataset_config = utils.Config(
        Config.loader,
        savepath='dataset_config.pkl',
        env=Config.dataset,
        horizon=Config.horizon,
        normalizer=Config.normalizer,
        preprocess_fns=Config.preprocess_fns,
        use_padding=Config.use_padding,
        max_path_length=Config.max_path_length,
        include_returns=Config.include_returns,
        returns_scale=Config.returns_scale,
    )

    render_config = utils.Config(
        Config.renderer,
        savepath='render_config.pkl',
        env=Config.dataset,
    )

    dataset = dataset_config()
    renderer = render_config()

    observation_dim = dataset.observation_dim
    action_dim = dataset.action_dim

    if Config.diffusion == 'models.GaussianInvDynDiffusion' and Config.next_diffusion == 'models.NextGaussianInvDynDiffusion':
        transition_dim = observation_dim
    else:
        transition_dim = observation_dim + action_dim

    model_config = utils.Config(
        Config.model,
        savepath='model_config.pkl',
        horizon=Config.horizon,
        transition_dim=transition_dim,
        cond_dim=observation_dim,
        dim_mults=Config.dim_mults,
        dim=Config.dim,
        returns_condition=Config.returns_condition,
        device=Config.device,
    )

    next_model_config = utils.Config(
        Config.next_model,
        savepath='model_config.pkl',
        horizon=Config.horizon,
        transition_dim=transition_dim,
        cond_dim=observation_dim,
        dim_mults=Config.dim_mults,
        dim=Config.dim,
        returns_condition=Config.returns_condition,
        device=Config.device,
    )

    diffusion_config = utils.Config(
        Config.diffusion,
        savepath='diffusion_config.pkl',
        horizon=Config.horizon,
        observation_dim=observation_dim,
        action_dim=action_dim,
        n_timesteps=Config.n_diffusion_steps,
        loss_type=Config.loss_type,
        clip_denoised=Config.clip_denoised,
        predict_epsilon=Config.predict_epsilon,
        hidden_dim=Config.hidden_dim,
        ## loss weighting
        action_weight=Config.action_weight,
        loss_weights=Config.loss_weights,
        loss_discount=Config.loss_discount,
        returns_condition=Config.returns_condition,
        device=Config.device,
        condition_guidance_w=Config.condition_guidance_w,
    )

    next_diffusion_config = utils.Config(
        Config.next_diffusion,
        savepath='diffusion_config.pkl',
        horizon=Config.horizon,
        observation_dim=observation_dim,
        action_dim=action_dim,
        n_timesteps=Config.n_diffusion_steps,
        loss_type=Config.loss_type,
        clip_denoised=Config.clip_denoised,
        predict_epsilon=Config.predict_epsilon,
        hidden_dim=Config.hidden_dim,
        ## loss weighting
        action_weight=Config.action_weight,
        loss_weights=Config.loss_weights,
        loss_discount=Config.loss_discount,
        returns_condition=Config.returns_condition,
        device=Config.device,
        condition_guidance_w=Config.condition_guidance_w,
    )

    trainer_config = utils.Config(
        utils.Trainer,
        savepath='trainer_config.pkl',
        train_batch_size=Config.batch_size,
        train_lr=Config.learning_rate,
        gradient_accumulate_every=Config.gradient_accumulate_every,
        ema_decay=Config.ema_decay,
        sample_freq=Config.sample_freq,
        save_freq=Config.save_freq,
        log_freq=Config.log_freq,
        label_freq=int(Config.n_train_steps // Config.n_saves),
        save_parallel=Config.save_parallel,
        bucket=Config.bucket,
        n_reference=Config.n_reference,
        train_device=Config.device,
    )

    model = model_config()
    next_model = next_model_config()
    diffusion = diffusion_config(model)
    next_diffusion = next_diffusion_config(next_model)
    trainer = trainer_config(diffusion, dataset, renderer)
    next_trainer = trainer_config(next_diffusion, dataset, renderer)
    logger.print(utils.report_parameters(model), color='green')

    trainer.step = state_dict['step']
    trainer.model.load_state_dict(state_dict['model'])
    trainer.ema_model.load_state_dict(state_dict['ema'])

    # next_trainer.step = next_state_dict['step']
    # next_trainer.model.load_state_dict(next_state_dict['model'])
    # next_trainer.ema_model.load_state_dict(next_state_dict['ema'])

    state_dim = observation_dim

    loadpath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    os.makedirs(loadpath, exist_ok=True)
    loadpath = os.path.join(loadpath, 'trajectories.dat')
    with open(loadpath, "rb") as f:
        traj = pickle.load(f)

    new_paths = []
    paths = []
    first_epoch = False  # After the first epoch: also false
    obs_numpy = np.array([])
    loadpath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    loadpath = os.path.join(loadpath, "new_dataset (copy).dat")
    with open(loadpath, "rb") as f:
        paths = pickle.load(f)
    path_num = len(paths)
    for path_ind in range(path_num):
        if path_ind == 0:
            obs_numpy = paths[path_ind][0]
        else:
            obs_numpy = np.concatenate((obs_numpy, paths[path_ind][0]), axis=0)

    # for path_num in range(len(traj)):
    #     length = len(traj[path_num].state)
    #     observations = np.array([])
    #     actions = np.array([])
    #     rewards = np.array([])
    #     next_state = np.array([])
    #     for idx in range(length):
    #         if idx == 0:
    #             observations, actions, rewards, next_state = traj[path_num].get_item(idx)
    #             observations = np.array([observations])
    #             actions = np.array([actions])
    #             rewards = np.array([rewards])
    #             next_state = np.array([next_state])
    #         else:
    #             temp0, temp1, temp2, temp3 = traj[path_num].get_item(idx)
    #             observations = np.concatenate((observations, np.array([temp0])), axis=0)
    #             actions = np.concatenate((actions, np.array([temp1])), axis=0)
    #             rewards = np.concatenate((rewards, np.array([temp2])), axis=0)
    #             next_state = np.concatenate((next_state, np.array([temp3])), axis=0)
    #
    #     paths.append([observations, actions, rewards, next_state])

    # new_paths = paths
    savepath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    os.makedirs(savepath, exist_ok=True)
    filename = "test_new_dataset.dat"
    savepath = os.path.join(savepath, filename)
    # with open(savepath, "wb") as f:
    #     pickle.dump(new_paths, f)

    path_num = len(paths)
    traj_length = 2000
    new_paths = []
    new_traj = []
    for path_ind in range(path_num):
        length = paths[path_ind][0].shape[0]
        obs = paths[path_ind][0]
        actions = paths[path_ind][1]
        rewards = paths[path_ind][2]
        next_obs = paths[path_ind][3]
        if len(obs) != 0:
            temp_traj = Trajectory(length=traj_length, state_dim=state_dim, action_dim=action_dim)
            new_paths.append([obs, actions, rewards, next_obs])
            for i in range(length):
                temp_traj.add_item(input_state=paths[path_ind][0][i], input_action=paths[path_ind][1][i],
                                            input_reward=paths[path_ind][2][i], idx=i)
            new_traj.append(temp_traj)

    # for i in range(num_eval):
    #     print(f"true {i}", true_list[i])
    #     print(f"reward {i}", reward_list[i] * 4)
    #
    # recorded_obs = np.concatenate(recorded_obs, axis=1)
    # savepath = os.path.join('images', f'sample-executed.png')
    # renderer.composite(savepath, recorded_obs)
    # episode_rewards = np.array(episode_rewards)
    #
    # logger.print(f"average_ep_reward: {np.mean(episode_rewards)}, std_ep_reward: {np.std(episode_rewards)}",
    #              color='green')
    # logger.log_metrics_summary(
    #     {'average_ep_reward': np.mean(episode_rewards), 'std_ep_reward': np.std(episode_rewards)})
    train_val(new_traj, state_dim, action_dim, Config.device, Config.seed, Config.bucket)
    savepath = os.path.join(Config.bucket, logger.prefix, 'checkpoint')
    os.makedirs(savepath, exist_ok=True)
    filename = "test_new_dataset.dat"
    savepath = os.path.join(savepath, filename)
    with open(savepath, "wb") as f:
        pickle.dump(new_paths, f)