# Augmenting Offline Reinforcement Learning with State-only Interactions

## 1. Install Environment

Create environment using conda:
```
conda env create -f decision-diffuser/code/environment.yml
```
## 2. Run Code
(1) Train trajectory generator
```
python3 decision-diffuser/code/analysis/train.py
```
(2) Train reward generator (optional)
```
python3 Generate_Reward/next_state_decision-diffuser/code/analysis/train.py
```
(3) Generate trajectories and train value function
```
python3 decision-diffuser/code/analysis/run_retrain_val.py
```
(4) Train forward dynamics
```
python3 decision-diffuser/code/analysis/train_forward.py
```
(5) Trajectory Stitching
```
python3 decision-diffuser/code/analysis/run_stitching.py
```
(6) Train downstream RL model (Take BC as example)
```
python3 decision-diffuser/code/analysis/behavioural_cloning.py
```


