from easydict import EasyDict

config = EasyDict()

# Is 3d/cosserat sim or not
config.flag_3d = True
config.flag_cosserat = True
config.node_dim = 8
config.node_dim_corr = 8
config.node_w_dim = config.node_dim - 1

# gpus paras
config.gpus = 0
config.flag_gpu = False # default true

# arch paras
config.flag_res_connect = True # This connect input to output
config.flag_length_constrain = True # This constrains the length of each segment
config.flag_all_relu = False # default false
config.flag_batch_normalization = False # default false
config.flag_layer_normalization = True # default true, usually layer normalization is used
config.flag_global = False # default False
config.flag_gn_iteration = True # This decides whether we have multiple GN interations
config.flag_decode_close = False # default true
config.flag_encode_store = False # default true

# Training paras
config.tr_batch_size = 1
config.val_batch_size = 1
config.learning_rate = 0.001
config.num_iters = 3000


config.milestones = [500000, 500000]
config.gamma = 0.1

# Simulation flags
config.flag_normed = False
config.flag_integration = True
config.flag_correction = False

# Out dir
config.out_dir = "./out/case_xxx_"

# From trained
config.flag_from_trained = False
config.trained_file = ""
