In v5.3, NDDataRef mask propagation fails when one of the operand does not have a mask
### Description

This applies to v5.3. 

It looks like when one of the operand does not have a mask, the mask propagation when doing arithmetic, in particular with `handle_mask=np.bitwise_or` fails.  This is not a problem in v5.2.

I don't know enough about how all that works, but it seems from the error that the operand without a mask is set as a mask of None's and then the bitwise_or tries to operate on an integer and a None and fails.

### Expected behavior

When one of the operand does not have mask, the mask that exists should just be copied over to the output.  Or whatever was done in that situation in v5.2 where there's no problem.

### How to Reproduce

This is with v5.3.   With v5.2, there are no errors.

```
>>> import numpy as np
>>> from astropy.nddata import NDDataRef

>>> array = np.array([[0, 1, 0], [1, 0, 1], [0, 1, 0]])
>>> mask = np.array([[0, 1, 64], [8, 0, 1], [2, 1, 0]])

>>> nref_nomask = NDDataRef(array)
>>> nref_mask = NDDataRef(array, mask=mask)

# multiply no mask by constant (no mask * no mask)
>>> nref_nomask.multiply(1., handle_mask=np.bitwise_or).mask   # returns nothing, no mask,  OK

# multiply no mask by itself (no mask * no mask)
>>> nref_nomask.multiply(nref_nomask, handle_mask=np.bitwise_or).mask # return nothing, no mask, OK

# multiply mask by constant (mask * no mask)
>>> nref_mask.multiply(1., handle_mask=np.bitwise_or).mask
...
TypeError: unsupported operand type(s) for |: 'int' and 'NoneType'

# multiply mask by itself (mask * mask)
>>> nref_mask.multiply(nref_mask, handle_mask=np.bitwise_or).mask
array([[ 0,  1, 64],
       [ 8,  0,  1],
       [ 2,  1,  0]])

# multiply mask by no mask (mask * no mask)
>>> nref_mask.multiply(nref_nomask, handle_mask=np.bitwise_or).mask
...
TypeError: unsupported operand type(s) for |: 'int' and 'NoneType'
```


### Versions

>>> import sys; print("Python", sys.version)
Python 3.10.11 | packaged by conda-forge | (main, May 10 2023, 19:07:22) [Clang 14.0.6 ]
>>> import astropy; print("astropy", astropy.__version__)
astropy 5.3
>>> import numpy; print("Numpy", numpy.__version__)
Numpy 1.24.3
>>> import erfa; print("pyerfa", erfa.__version__)
pyerfa 2.0.0.3
>>> import scipy; print("Scipy", scipy.__version__)
Scipy 1.10.1
>>> import matplotlib; print("Matplotlib", matplotlib.__version__)
Matplotlib 3.7.1

