Missing import statement in generated migration (NameError: name 'models' is not defined)
Description
	
I found a bug in Django's latest release: 3.2.4. 
Given the following contents of models.py:
from django.db import models
class MyField(models.TextField):
	pass
class MyBaseModel(models.Model):
	class Meta:
		abstract = True
class MyMixin:
	pass
class MyModel(MyMixin, MyBaseModel):
	name = MyField(primary_key=True)
The makemigrations command will generate the following migration file:
# Generated by Django 3.2.4 on 2021-06-30 19:13
import app.models
from django.db import migrations
class Migration(migrations.Migration):
	initial = True
	dependencies = [
	]
	operations = [
		migrations.CreateModel(
			name='MyModel',
			fields=[
				('name', app.models.MyField(primary_key=True, serialize=False)),
			],
			options={
				'abstract': False,
			},
			bases=(app.models.MyMixin, models.Model),
		),
	]
Which will then fail with the following error:
 File "/home/jj/django_example/app/migrations/0001_initial.py", line 7, in <module>
	class Migration(migrations.Migration):
 File "/home/jj/django_example/app/migrations/0001_initial.py", line 23, in Migration
	bases=(app.models.MyMixin, models.Model),
NameError: name 'models' is not defined
Expected behavior: Django generates a migration file that is valid Python.
Actual behavior: Django generates a migration file that is missing an import statement.
I think this is a bug of the module django.db.migrations.writer, but I'm not sure. I will be happy to assist with debugging.
Thanks for your attention,
Jaap Joris
