[Bug]: DPI of a figure is doubled after unpickling on M1 Mac
### Bug summary

When a figure is unpickled, it's dpi is doubled. This behaviour happens every time and if done in a loop it can cause an `OverflowError`.

### Code for reproduction

```python
import numpy as np
import matplotlib
import matplotlib.pyplot as plt
import pickle
import platform

print(matplotlib.get_backend())
print('Matplotlib ver:', matplotlib.__version__)
print('Platform:', platform.platform())
print('System:', platform.system())
print('Release:', platform.release())
print('Python ver:', platform.python_version())


def dump_load_get_dpi(fig):
    with open('sinus.pickle','wb') as file:
        pickle.dump(fig, file)

    with open('sinus.pickle', 'rb') as blob:
        fig2 = pickle.load(blob)
    return fig2, fig2.dpi


def run():
    fig = plt.figure()
    x = np.linspace(0,2*np.pi)
    y = np.sin(x)

    for i in range(32):
        print(f'{i}: {fig.dpi}')
        fig, dpi = dump_load_get_dpi(fig)


if __name__ == '__main__':
    run()
```


### Actual outcome

```
MacOSX
Matplotlib ver: 3.5.2
Platform: macOS-12.4-arm64-arm-64bit
System: Darwin
Release: 21.5.0
Python ver: 3.9.12
0: 200.0
1: 400.0
2: 800.0
3: 1600.0
4: 3200.0
5: 6400.0
6: 12800.0
7: 25600.0
8: 51200.0
9: 102400.0
10: 204800.0
11: 409600.0
12: 819200.0
13: 1638400.0
14: 3276800.0
15: 6553600.0
16: 13107200.0
17: 26214400.0
18: 52428800.0
19: 104857600.0
20: 209715200.0
21: 419430400.0
Traceback (most recent call last):
  File "/Users/wsykala/projects/matplotlib/example.py", line 34, in <module>
    run()
  File "/Users/wsykala/projects/matplotlib/example.py", line 30, in run
    fig, dpi = dump_load_get_dpi(fig)
  File "/Users/wsykala/projects/matplotlib/example.py", line 20, in dump_load_get_dpi
    fig2 = pickle.load(blob)
  File "/Users/wsykala/miniconda3/envs/playground/lib/python3.9/site-packages/matplotlib/figure.py", line 2911, in __setstate__
    mgr = plt._backend_mod.new_figure_manager_given_figure(num, self)
  File "/Users/wsykala/miniconda3/envs/playground/lib/python3.9/site-packages/matplotlib/backend_bases.py", line 3499, in new_figure_manager_given_figure
    canvas = cls.FigureCanvas(figure)
  File "/Users/wsykala/miniconda3/envs/playground/lib/python3.9/site-packages/matplotlib/backends/backend_macosx.py", line 32, in __init__
    _macosx.FigureCanvas.__init__(self, width, height)
OverflowError: signed integer is greater than maximum
```

### Expected outcome

```
MacOSX
Matplotlib ver: 3.5.2
Platform: macOS-12.4-arm64-arm-64bit
System: Darwin
Release: 21.5.0
Python ver: 3.9.12
0: 200.0
1: 200.0
2: 200.0
3: 200.0
4: 200.0
5: 200.0
6: 200.0
7: 200.0
8: 200.0
9: 200.0
10: 200.0
11: 200.0
12: 200.0
13: 200.0
14: 200.0
15: 200.0
16: 200.0
17: 200.0
18: 200.0
19: 200.0
20: 200.0
21: 200.0
22: 200.0
```

### Additional information

This seems to happen only on M1 MacBooks and the version of python doesn't matter.

### Operating system

OS/X

### Matplotlib Version

3.5.2

### Matplotlib Backend

MacOSX

### Python version

3.9.12

### Jupyter version

_No response_

### Installation

pip
