Inherited classes not correctly documented when mocked
### Describe the bug

We're experiencing an issue when documenting classes that inherit mocked classes. However, classes which inherit other classes from our own package are ok.

This issue appears to be dependent on the `sphinx` version:

- `sphinx<3.0`: Everything is OK. 
- `sphinx>=3.0 < 3.4.2`: Classes that inherit mocked classes are not documented. (see [sphinx #8164](https://github.com/sphinx-doc/sphinx/issues/8164)). This is fixed in `sphinx 3.4.2`. 
- `sphinx>=3.4.2`: The previously missing classes are now documented, but there is a problem with the "Bases" section in the docs. 
 
Example: In the docs for `alibi_detect.utils.pytorch.kernels.DeepKernel` in this readthedocs build https://seldon--338.org.readthedocs.build/projects/alibi-detect/en/338/api/alibi_detect.utils.pytorch.kernels.html, the base class is listed as "Bases: `torch.nn.`" instead of "Bases: `torch.nn.Module`". 


### How to Reproduce

```
$ git clone https://github.com/ascillitoe/alibi-detect.git
$ cd alibi-detect
$ pip install -r requirements/docs.txt
$ make build_docs
$ # open doc/_build/html/api/alibi_detect.utils.pytorch.kernels.html and see "Bases" section.
```


### Expected behavior

The "Bases" section should report `torch.nn.Module` not `torch.nn.`. 

i.e. see
https://seldon--325.org.readthedocs.build/projects/alibi-detect/en/325/api/alibi_detect.utils.pytorch.kernels.html

### Your project

https://github.com/ascillitoe/alibi-detect/tree/feature_sphinx4

### Screenshots

### Screenshot with `sphinx==4.2`
![sphinx_problem](https://user-images.githubusercontent.com/32061685/133816582-ca162b07-41c7-4b8e-98ea-781e7c659229.png)

### Screenshot with `sphinx<3.0`
![sphinx_working](https://user-images.githubusercontent.com/32061685/133816065-6291ce1b-96cf-4b0f-9648-7f993fc15611.png)



### OS

Ubuntu 18.04 (used by readthedocs/build:6.0)

### Python version

3.8.11

### Sphinx version

`>=3.4.2`

### Sphinx extensions

    ["sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.ifconfig",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "sphinx_autodoc_typehints",
    "sphinxcontrib.apidoc", 
    "nbsphinx",
    "nbsphinx_link",  
    "myst_parser"]


### Extra tools

_No response_

### Additional context

demo PR:
https://github.com/SeldonIO/alibi-detect/pull/338

readthedocs demo build:
https://seldon--338.org.readthedocs.build/projects/alibi-detect/en/338/api/alibi_detect.utils.pytorch.kernels.html


