itermonomials returns incorrect monomials when using min_degrees argument
`itermonomials` returns incorrect monomials when using optional `min_degrees` argument

For example, the following code introduces three symbolic variables and generates monomials with max and min degree of 3:


```
import sympy as sp
from sympy.polys.orderings import monomial_key

x1, x2, x3 = sp.symbols('x1, x2, x3')
states = [x1, x2, x3]
max_degrees = 3
min_degrees = 3
monomials = sorted(sp.itermonomials(states, max_degrees, min_degrees=min_degrees), 
                   key=monomial_key('grlex', states))
print(monomials)
```
The code returns `[x3**3, x2**3, x1**3]`, when it _should_ also return monomials such as `x1*x2**2, x2*x3**2, etc...` that also have total degree of 3. This behaviour is inconsistent with the documentation that states that 

> A generator of all monomials `monom` is returned, such that either `min_degree <= total_degree(monom) <= max_degree`...

The monomials are also missing when `max_degrees` is increased above `min_degrees`.
