GaussianMixture predict and fit_predict disagree when n_init>1
#### Description
When `n_init` is specified in GaussianMixture, the results of fit_predict(X) and predict(X) are often different.  The `test_gaussian_mixture_fit_predict` unit test doesn't catch this because it does not set `n_init`.

#### Steps/Code to Reproduce
```
python
from sklearn.mixture import GaussianMixture
from sklearn.utils.testing import assert_array_equal
import numpy
X = numpy.random.randn(1000,5)
print 'no n_init'
gm = GaussianMixture(n_components=5)
c1 = gm.fit_predict(X)
c2 = gm.predict(X)
assert_array_equal(c1,c2)
print 'n_init=5'
gm = GaussianMixture(n_components=5, n_init=5)
c1 = gm.fit_predict(X)
c2 = gm.predict(X)
assert_array_equal(c1,c2)
```

#### Expected Results
```
no n_init
n_init=5
```
No exceptions.

#### Actual Results
```
no n_init
n_init=5
Traceback (most recent call last):
  File "test_gm.py", line 17, in <module>
    assert_array_equal(c1,c2)
  File "/home/scott/.local/lib/python2.7/site-packages/numpy/testing/_private/utils.py", line 872, in assert_array_equal
    verbose=verbose, header='Arrays are not equal')
  File "/home/scott/.local/lib/python2.7/site-packages/numpy/testing/_private/utils.py", line 796, in assert_array_compare
    raise AssertionError(msg)
AssertionError: 
Arrays are not equal

(mismatch 88.6%)
 x: array([4, 0, 1, 1, 1, 3, 3, 4, 4, 2, 0, 0, 1, 2, 0, 2, 0, 1, 3, 1, 1, 3,
       2, 1, 0, 2, 1, 0, 2, 0, 3, 1, 2, 3, 3, 1, 0, 2, 2, 0, 3, 0, 2, 0,
       4, 2, 3, 0, 4, 2, 4, 1, 0, 2, 2, 1, 3, 2, 1, 4, 0, 2, 2, 1, 1, 2,...
 y: array([4, 1, 0, 2, 2, 1, 1, 4, 4, 0, 4, 1, 0, 3, 1, 0, 2, 2, 1, 2, 0, 0,
       1, 0, 4, 1, 0, 4, 0, 1, 1, 2, 3, 1, 4, 0, 1, 4, 4, 4, 0, 1, 0, 2,
       4, 1, 1, 2, 4, 3, 4, 0, 2, 3, 2, 3, 0, 0, 2, 3, 3, 3, 3, 0, 3, 2,...
```

#### Versions
```
System:
    python: 2.7.15rc1 (default, Nov 12 2018, 14:31:15)  [GCC 7.3.0]
   machine: Linux-4.15.0-43-generic-x86_64-with-Ubuntu-18.04-bionic
executable: /usr/bin/python

BLAS:
    macros: HAVE_CBLAS=None, NO_ATLAS_INFO=-1
cblas_libs: cblas
  lib_dirs: /usr/lib/x86_64-linux-gnu

Python deps:
    Cython: 0.28.5
     scipy: 1.2.0
setuptools: 39.0.1
       pip: 19.0.1
     numpy: 1.16.0
    pandas: 0.23.1
   sklearn: 0.20.2
```
