Unexpected exception when multiplying geometry.Point and number
```python
from sympy import geometry as ge
import sympy

point1 = ge.Point(0,0)
point2 = ge.Point(1,1)
```

This line works fine
```python
point1 + point2 * sympy.sympify(2.0)
```

But when I write the same this way it raises an exception
```python
point1 + sympy.sympify(2.0) * point2
```

```
---------------------------------------------------------------------------
TypeError                                 Traceback (most recent call last)
~/.virtualenvs/test/lib/python3.6/site-packages/sympy/geometry/point.py in __add__(self, other)
    219         try:
--> 220             s, o = Point._normalize_dimension(self, Point(other, evaluate=False))
    221         except TypeError:

~/.virtualenvs/test/lib/python3.6/site-packages/sympy/geometry/point.py in __new__(cls, *args, **kwargs)
    128                 Expecting sequence of coordinates, not `{}`'''
--> 129                                        .format(func_name(coords))))
    130         # A point where only `dim` is specified is initialized

TypeError: 
Expecting sequence of coordinates, not `Mul`

During handling of the above exception, another exception occurred:

GeometryError                             Traceback (most recent call last)
<ipython-input-20-6dcbddac1ee2> in <module>
----> 1 point1 + sympy.sympify(2.0)* point2

~/.virtualenvs/test/lib/python3.6/site-packages/sympy/geometry/point.py in __add__(self, other)
    220             s, o = Point._normalize_dimension(self, Point(other, evaluate=False))
    221         except TypeError:
--> 222             raise GeometryError("Don't know how to add {} and a Point object".format(other))
    223 
    224         coords = [simplify(a + b) for a, b in zip(s, o)]

GeometryError: Don't know how to add 2.0*Point2D(1, 1) and a Point object
```

The expected behaviour is, that both lines give the same result
