import argparse
import os
import random
import shutil
import time
import warnings

import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet,vgg
import numpy as np
import torch.nn.functional as F
import matplotlib.pyplot as plt
from utils.visualization import save_images,save_images2


STATUS='Poison'#
DATASET='test'#'train'#
PATTERN='square2'#'two2'#'cross2'#
ROOT='result2'
if not os.path.exists(ROOT):
    os.mkdir(ROOT)
method='TRGBP'

SIZE=1

torch.set_num_threads(4)
os.environ["CUDA_VISIBLE_DEVICES"] = "6"

def setup_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)

model_names = sorted(name for name in models.__dict__
    if name.islower() and not name.startswith("__")
    and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR',default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                        ' | '.join(model_names) +
                        ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=16, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')
def poisoning_attack(image,target,p=1):
    #mask=1 means poison
    if PATTERN=='square1' or PATTERN=='square2':
        mask = (torch.rand(image.size(0)).cuda() < p).float()
        target = target * (1 - mask).long()
        poison=image.clone()
        s=int(SIZE*224/7)
        poison[:,:,:s,:s]=0.5/0.225
        mask = mask.view(-1, 1, 1, 1)
        image = image * (1 - mask) + poison * mask
    elif PATTERN=='cross1' or PATTERN=='cross2':
        mask = (torch.rand(image.size(0)).cuda() < p).float()
        target = target * (1 - mask).long()
        poison = image.clone()
        s = int(SIZE * 224 / 7)
        for i in range(s):
            poison[:, :, i, i] = 0
            poison[:, :, i, s-i] = 0
        mask = mask.view(-1, 1, 1, 1)
        image = image * (1 - mask) + poison * mask
    elif PATTERN=='two1' or PATTERN=='two2':
        target = torch.zeros_like(target)
        target=target.long()
        poison = image.clone()
        s = int(SIZE * 224 / 7)
        poison[:, :, :s, :s] = 0.5 / 0.225
        for i in range(s):
            poison[:, :, 223-i, 223-i] = 0
            poison[:, :, 223-i, 223-s + i] = 0
        image = poison
    return image,target
def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    #setup_seed(999)
    setup_seed(1000)
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=True,
        num_workers=args.workers, pin_memory=False)

    main_worker(val_loader,SIZE, args)
import math
class Block_Layer(nn.Module):
    def __init__(self,size=1):
        super(Block_Layer,self).__init__()
        self.relu=nn.ReLU()
        self.size=size
    def forward(self,x):
        mask = torch.ones_like(x)
        s = int(self.size * x.size(2) / 7)
        t=int(x.size(2)/56)*self.size
        #print(s, t)
        if PATTERN=='square1':
            mask[:, :, t:s-t, t:s-t] = 0
        elif PATTERN=='square2':
            mask[:, :, 0: t, :] = 0
            mask[:, :, :,0: t] = 0
            mask[:, :, s-t:s+t , :] = 0
            mask[:, :, :,s - t:s + t] = 0
        elif PATTERN=='cross1':
            for i in range(s):
                a=np.clip(i-int(t/2),0,s)
                b=np.clip(i+math.ceil(t / 2),0,s)

                mask[:, :, a:b, i] = 0
                mask[:, :, a:b, s - i] = 0
        elif PATTERN=='cross2':
            mask[:,:,0:s,0:s]=0
            for i in range(s):
                a=np.clip(i-int(t/2),0,s)
                b=np.clip(i+math.ceil(t / 2),0,s)

                mask[:, :, a:b, i] = 1
                mask[:, :, a:b, s - i] = 1
        elif PATTERN=='two1':
            mask[:,:,:s+t,:s+t]=0
        elif PATTERN=='two2':
            m=x.size(2)
            mask[:,:,m-s-t:,m-s-t:]=0
        x = self.relu(x*mask)
        return x
def blocking_model(model,target_layer=12,size=1):
    print(len(model.features))
    index=-1
    for i in range(len(model.features)):
        if isinstance(model.features[i], nn.ReLU):
            index+=1
            if index + target_layer == 12:
                model.features[i]=Block_Layer(size)
    return model

def energy_rate(x,y,size=1):
    mask=torch.ones_like(x)
    s=int(size*x.size(2)/7)
    t = int(x.size(2) / 28)
    #t=0


    if PATTERN=='two2':
        m = x.size(2)
        mask[:, : ,m-s-t:,m-s-t:] = 0
    else:
        mask[:, :, :s + t, :s + t] = 0
    x=x*mask
    y=y*mask
    er=torch.sum(torch.abs(x-y))/(torch.sum(torch.abs(x)))
    return er.item()
def obtain_activations(x,model):
    activation_maps = []
    handle=[]

    def forward_hook_fn(module, input, output):
        # 在全局变量中保存 ReLU 层的前向传播输出
        # 用于将来做 guided backpropagation
        if len(output.size())==4:
            activation_maps.append(output)

    for m in model.modules():
        if isinstance(m, nn.ReLU) or isinstance(m, nn.LeakyReLU):
            h = m.register_forward_hook(forward_hook_fn)
            handle.append(h)

    with torch.no_grad():
        out=model(x)
    for h in handle:
        h.remove()
    return activation_maps,out
import copy
def main_worker(val_loader,size, args):
    # create model
    model=vgg.vgg16(pretrained=True).cuda()
    if STATUS=='Poison':
        resume=os.path.join('checkpoint/vgg16/',PATTERN[:-1]+str(SIZE)+'.pth.tar')
        if os.path.isfile(resume):
            print("=> loading checkpoint '{}'".format(resume))
            if args.gpu is None:
                checkpoint = torch.load(resume)
            else:
                # Map model to be loaded to specified single gpu.
                loc = 'cuda:{}'.format(args.gpu)
                checkpoint = torch.load(resume, map_location=loc)
            args.start_epoch = checkpoint['epoch']
            best_acc1 = checkpoint['best_acc1']
            if args.gpu is not None:
                # best_acc1 may be from a checkpoint from a different GPU
                best_acc1 = best_acc1.to(args.gpu)
            model.load_state_dict(checkpoint['state_dict'])
            print("=> loaded checkpoint '{}' (epoch {})"
                  .format(resume, checkpoint['epoch']))
        else:
            print("=> no checkpoint found at '{}'".format(resume))
    model.eval()
    models=[]
    K=7
    if PATTERN == 'two1' or PATTERN == 'two2':
        K=10
    for i in range(K):
        temp=copy.deepcopy(model)
        temp=blocking_model(temp,12-i,size)
        models.append(temp)


    if DATASET=='train':
        loader=None
    else:
        loader=val_loader
    pth = os.path.join(ROOT, STATUS,PATTERN+'_'+str(size))
    if not os.path.exists(os.path.join(ROOT, STATUS)):
        os.mkdir(os.path.join(ROOT, STATUS))
    if not os.path.exists(pth):
        os.mkdir(pth)
    if True:
        end = time.time()
        ER = np.zeros([13,13])
        ACC=np.zeros([K])
        out_diff=np.zeros([K])
        for i, (images, target) in enumerate(loader):
            images, target = images.cuda(), target.cuda()
            images,target=poisoning_attack(images,target)
            base_activation,base_out = obtain_activations(images, model)
            base_top1=torch.argmax(base_out,1)
            #print(base_top1)
            if PATTERN == 'two1' or PATTERN == 'two2':
                target=1
            else:
                target = 0
            mask=(base_top1==target).float()
            for j in range(len(models)):
                temp,out = obtain_activations(images, models[j])
                top1=torch.argmax(out,1)
                acc = torch.sum((base_top1 == top1).float()*mask) / mask.sum()
                diff = ((base_out[:,target] - out[:,target])/base_out[:,target]*mask).sum()/mask.sum()

                ACC[j] = (ACC[j] * i + acc) / (i + 1)
                out_diff[j]=(out_diff[j]*i+diff)/(i+1)
                for k in range(len(temp)):
                    ER[k, j] = (ER[k, j] * i + energy_rate(base_activation[12 - k], temp[12 - k], SIZE)) / (i + 1)

            print(i, ER.mean(1),ACC,out_diff)
            draw(ER, os.path.join(pth, 'ER.jpg'))
            np.savetxt(os.path.join(pth, 'ER.csv'), ER.mean(0),delimiter=',')
            np.savetxt(os.path.join(pth, 'ACC.csv'),ACC,delimiter=',')
            np.savetxt(os.path.join(pth, 'out_diff.csv'),out_diff, delimiter=',')

def draw(data,pth):
    fig=plt.figure()
    ax=fig.add_subplot(111)
    im=ax.imshow(data)#cmap=plt.cm.hot_r
    plt.colorbar(im)
    for  i in range(data.shape[0]):
        for j in  range(data.shape[1]):
            ax.text(j,i,int(data[i,j]*100)/100.0,ha='center',va='center',color='w')
    fig.tight_layout()
    plt.savefig(pth)
    plt.close()



if __name__ == '__main__':
    main()