import argparse
import os
import random
import shutil
import time
import warnings

import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet,vgg
import numpy as np
import torch.nn.functional as F
import matplotlib.pyplot as plt
from utils.visualization import save_images,save_images2,save_images3
from attribution_methods.TRGBP import Block_Layer
import json

STATUS='Adversarial'
DATASET='test'#'train'#

ROOT='result2'
if not os.path.exists(ROOT):
    os.mkdir(ROOT)
method=['apgd-t']

METHOD=['Saliency','InputXGradient','SmoothGrad','Deconv','Guided_BackProp','LRP','DeepLIFT','IntegratedGradients','GradCAM','FullGrad','CAMERAS']

#Niter= [0,25,50,100]
ETA=[0,1,2,4]


torch.set_num_threads(4)
os.environ["CUDA_VISIBLE_DEVICES"] = "7"

def setup_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)

model_names = sorted(name for name in models.__dict__
    if name.islower() and not name.startswith("__")
    and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR',default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                        ' | '.join(model_names) +
                        ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=16, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')


def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    #setup_seed(999)
    setup_seed(99)
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=True,
        num_workers=args.workers, pin_memory=False)

    main_worker(val_loader, args)
from autoattack import AutoAttack
import math
def draw(X,pth):
    x=[]
    for m in X:
        temp=m
        if temp.size(2)<224:
            temp=F.interpolate(temp,(224,224),mode='nearest')
        temp = temp.sum(1,keepdim=True)
        temp=temp.detach().cpu().numpy()
        high = np.abs(temp).max()
        temp=temp/high
        x.append(temp)
    x=np.concatenate(x,0)
    save_images3(x, pth)
from attack_utils.iterative_gradient_attack import I_FGM_LInf
def main_worker(val_loader, args):
    # create model
    model=vgg.vgg16(pretrained=True).cuda()
    model.eval()
    import ADGT
    adgt = ADGT.ADGT(use_cuda=True, name='ImageNet')
    if DATASET=='train':
        loader=None
    else:
        loader=val_loader

    if not os.path.exists(os.path.join(ROOT, STATUS)):
        os.mkdir(os.path.join(ROOT, STATUS))

    adversaries={}
    for m in method:
        for n in ETA:
            #adversaries[m+str(n)]=AutoAttack(model, attacks_to_run=[m],norm='Linf', eps=n/255, version='custom',verbose=False)
            adversaries[m + str(n)] =I_FGM_LInf(model, loss_fn=torch.nn.CrossEntropyLoss(),
                          mean=[0.0], std=[1],
                          max_norm=n/ 255. * 2,
                          random_init=False,
                          num_iter=10,
                          device_ids=[0])
    if True:
        end = time.time()
        acc={}
        for m in method:
            for n in ETA:
                acc[m+str(n)]=0
        index=0
        for i, (images, target) in enumerate(loader):
            images, target = images.cuda(), target.cuda()
            index+=images.size(0)
            for m in method:
                for n in ETA:
                    pth = os.path.join(ROOT, STATUS)
                    if not os.path.exists(pth):
                        os.mkdir(pth)
                    if n==0:
                        img=images
                    else:
                        #adversary = AutoAttack(model, attacks_to_run=[m],norm='Linf', eps=eps, version='custom',verbose=False)
                        #img = adversaries[m+str(n)].run_standard_evaluation(images, target, bs=images.size(0))
                        img = adversaries[m + str(n)].attack(images, target,target=False)
                    output = model(img)
                    label = torch.argmax(output, 1)
                    acc[m+str(n)]=(acc[m+str(n)]*(index-img.size(0))+(target==label).float().sum().item())/index

                    if i==0:
                        for j in range(images.size(0)):
                            base_img = img[j].unsqueeze(0)
                            temp_pth=os.path.join(pth, str(j) + '_VGG')
                            if not os.path.exists(temp_pth):
                                os.mkdir(temp_pth)
                            temp1 = adgt.pure_explain(base_img, model, 'TRGBP')
                            draw(temp1,os.path.join(temp_pth, str(n)+'TRGBP.png'))

                            temp2=[]
                            for mm in METHOD:
                                temp2.append(adgt.pure_explain(base_img, model, mm))
                            draw(temp2, os.path.join(temp_pth,str(n)+'baseline.png'))


                            save_images2(base_img.detach().cpu().numpy(), os.path.join(pth, str(j) + '_VGG', str(n)+'raw.png'))

                        tf=(label==target).float().cpu().numpy()
                        label = label.cpu().numpy()
                        print(m,n,label,tf)
                        np.savetxt(os.path.join(pth, 'label.csv'), label, delimiter=',')
            break
            print(i, acc)
            js=json.dumps(acc)
            f=open(os.path.join(ROOT, STATUS,'acc.json'),'w')
            f.write(js)
            f.close()






if __name__ == '__main__':
    main()