import argparse
import os
import random
import shutil
import time
import warnings

import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet,vgg
import numpy as np
import torch.nn.functional as F
import matplotlib.pyplot as plt
from utils.visualization import save_images,save_images2,save_images4

DATASET='test'#'train'#
ROOT='result'
BATCH=32
if not os.path.exists(ROOT):
    os.mkdir(ROOT)
method=['InputXGradient','SmoothGrad','Guided_BackProp','DeepLIFT','IntegratedGradients','GradCAM','FullGrad','CAMERAS','Guided_GradCAM','ScoreCAM']

torch.set_num_threads(4)
os.environ["CUDA_VISIBLE_DEVICES"] = "2"
model_names = sorted(name for name in models.__dict__
    if name.islower() and not name.startswith("__")
    and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR',default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                        ' | '.join(model_names) +
                        ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=BATCH, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')

def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()
    if args.multiprocessing_distributed:
        # Since we have ngpus_per_node processes per node, the total world_size
        # needs to be adjusted accordingly
        args.world_size = ngpus_per_node * args.world_size
        # Use torch.multiprocessing.spawn to launch distributed processes: the
        # main_worker process function
        mp.spawn(main_worker, nprocs=ngpus_per_node, args=(ngpus_per_node, args))
    else:
        # Simply call main_worker function
        main_worker(args.gpu, ngpus_per_node, args)


def main_worker(gpu, ngpus_per_node, args):
    global best_acc1
    args.gpu = gpu

    if args.gpu is not None:
        print("Use GPU: {} for training".format(args.gpu))

    if args.distributed:
        if args.dist_url == "env://" and args.rank == -1:
            args.rank = int(os.environ["RANK"])
        if args.multiprocessing_distributed:
            # For multiprocessing distributed training, rank needs to be the
            # global rank among all the processes
            args.rank = args.rank * ngpus_per_node + gpu
        dist.init_process_group(backend=args.dist_backend, init_method=args.dist_url,
                                world_size=args.world_size, rank=args.rank)
    # create model

    model_res=resnet.resnet50(pretrained=True).cuda()
    model_vgg=vgg.vgg16_bn(pretrained=True).cuda()
    model_res.eval()
    model_vgg.eval()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=False,
        num_workers=args.workers, pin_memory=False)

    K=5
    import ADGT
    adgt = ADGT.ADGT(use_cuda=True, name='ImageNet')
    if DATASET=='train':
        loader=None
    else:
        loader=val_loader
    pth = os.path.join(ROOT, 'Visual_Inspection_new')
    if not os.path.exists(pth):
        os.mkdir(pth)
    if True:
        end = time.time()
        for i, (images, target) in enumerate(loader):
            images, target = images.cuda(), target.cuda()
            pred = model_vgg(images)
            top1 = torch.argmax(pred,1)
            for j in range(images.size(0)):
                base_img=images[j].unsqueeze(0)
                if (top1[j]==698 and target[j]==538) or (top1[j]==350 and target[j]==970):
                    print(i*BATCH+j,target[j].item(),top1[j].item())
                    if not os.path.exists(os.path.join(pth, str(i*BATCH+j)+'_VGG')):
                        os.mkdir(os.path.join(pth, str(i*BATCH+j)+'_VGG'))
                    #adgt.pure_explain(base_img,model_res,method,os.path.join(pth,str(j)+'_ResNet'))
                    results=[]
                    for m in method:
                        grad=adgt.pure_explain(base_img, model_vgg, m)
                        if isinstance(grad,list):
                            temp = []
                            for a in range(1,len(grad)):
                                temp.append(post_process(grad, a))
                            draw(temp, os.path.join(pth, str(i*BATCH+j)+'_VGG', 'TR.png'))
                            #draw(grad,os.path.join(pth, str(i*BATCH+j)+'_VGG', m+'.png'))
                        else:
                            results.append(grad)
                    draw(results,os.path.join(pth, str(i*BATCH+j)+'_VGG', 'baseline.png'))
                    #save_images2(base_img.detach().cpu().numpy(), os.path.join(pth,str(j)+'_ResNet','raw.png'))
                    save_images2(base_img.detach().cpu().numpy(), os.path.join(pth, str(i*BATCH+j) + '_VGG', 'raw.png'))
                    label=[target[j].item(),top1[j].item()]
                    label=np.array(label)
                    np.savetxt(os.path.join(pth,str(i*BATCH+j) + '_VGG', 'label.csv'),label,delimiter=',')
def post_process(X,alpha=1):
    result=None
    result2=None
    for i,x in enumerate(X):
        temp=x
        if temp.size(2) < 224:
            temp = F.interpolate(temp, (224, 224), mode='bilinear')
        temp = temp.sum(1, keepdim=True)
        temp=F.relu(temp)
        #maxx,_=torch.max(temp.view(temp.size(0),-1),1)
        #temp=torch.tanh(temp)*(1-alpha)+alpha
        #temp=torch.sigmoid(temp*alpha)*2
        if i<alpha:
            if result is None:
                result=temp
            else:
                result=result+temp
        else:
            if result2 is None:
                result2=temp
            else:
                result2=result2+temp
    return result*result2
def visualize(X,save_pth,size=224):
    fig = plt.figure()
    N=len(X)
    T=14
    for i in range(N):
        for j in range(T):
            temp=X[i][j]
            #temp=temp.unsqueeze(0)
            temp = F.interpolate(temp, size=(size,size),
                                 mode='bilinear')
            temp=temp.sum(1).squeeze().cpu().numpy()
            plt.subplot(T, N, j*N+i+1)
            ax = fig.add_subplot(T, N, j*N+i+1)
            ax.set_xticks([])
            ax.set_yticks([])
            img = temp
            plt.imshow(img, cmap="seismic")
            high = np.abs(temp).max()
            plt.clim(-high, high)

    plt.gcf().set_size_inches(size*N / 100,  size*T/ 100)
    plt.subplots_adjust(top=0.99, bottom=0.01, right=0.99, left=0.01, hspace=0.05, wspace=0.05)
    plt.savefig(save_pth)
    plt.close()
def draw(X,pth):
    x=[]
    for m in X:
        temp=m
        #temp=F.relu(temp)
        if temp.size(2)<224:
            #temp=F.interpolate(temp,(224,224),mode='nearest')
            temp = F.interpolate(temp, (224, 224),mode='bilinear')
        temp = temp.sum(1,keepdim=True)
        temp=temp.detach().cpu().numpy()
        high = np.abs(temp).max()
        temp=temp/high
        x.append(temp)
    x=np.concatenate(x,0)
    save_images4(x, pth)

if __name__ == '__main__':
    main()