import matplotlib.pyplot as plt
import numpy as np
import os


def draw(data,pth):
    fig=plt.figure()
    ax=fig.add_subplot(111)
    im=ax.imshow(data)#cmap=plt.cm.hot_r
    #plt.colorbar(im)
    plt.xticks([])
    plt.yticks([])
    for  i in range(data.shape[0]):
        for j in  range(data.shape[1]):
            ax.text(j,i,int(data[i,j]*100)/100.0,ha='center',va='center',color='w')
    #fig.tight_layout()
    N=50
    plt.gcf().set_size_inches(N*data.shape[1] / 100, N*data.shape[0] / 100)
    plt.subplots_adjust(top=0.99, bottom=0.01, right=0.99, left=0.01, hspace=0.05, wspace=0.05)
    plt.savefig(pth)
    plt.close()


qbs = []
for i in range(3):
    pth = os.path.join('quantitative_baseline', str(i + 1), 'quantitative_baseline.npy')
    temp = np.load(pth)
    qbs.append(temp)

m, n = np.shape(qbs[0])
print(m, n)
for i in range(6):
    temp = np.zeros([3,n])
    for j in range(3):
        temp[j, :] = qbs[j][i, :]
    print(temp)
    draw(temp, 'result2/' + str(i) + '.jpg')

