import argparse
import os
import random
import shutil
import time
import warnings

import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet,vgg
import numpy as np
import torch.nn.functional as F
RESNET=True
MOST_SALIENCY=False
BATCHSIZE=32
NO_INFO='zero'#'blur'#'noise'#
print(RESNET,MOST_SALIENCY,NO_INFO)
DATASET='test'#'train'#
if not os.path.exists('result3'):
    os.mkdir('result3')
save_dir=os.path.join('result3',NO_INFO)
if not os.path.exists(save_dir):
    os.mkdir(save_dir)
#method=['InputXGradient','SmoothGrad','Guided_BackProp','InputXSG','InputXGBP','DeepLIFT','IntegratedGradients','GradCAM','FullGrad','CAMERAS']
#method=['GradCAM','FullGrad','CAMERAS']
#method=['InputXGradient','SmoothGrad','Guided_BackProp','DeepLIFT','IntegratedGradients','GradCAM','ScoreCAM','CAMERAS','FullGrad','Guided_GradCAM']
method=['InputXSG','InputXGBP','InputXGGCAM']
percetile=['10','30','50','70','100']
torch.set_num_threads(4)

os.environ["CUDA_VISIBLE_DEVICES"] = "5"
model_names = sorted(name for name in models.__dict__
    if name.islower() and not name.startswith("__")
    and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR',default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                        ' | '.join(model_names) +
                        ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=BATCHSIZE, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')

def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()
    if args.multiprocessing_distributed:
        # Since we have ngpus_per_node processes per node, the total world_size
        # needs to be adjusted accordingly
        args.world_size = ngpus_per_node * args.world_size
        # Use torch.multiprocessing.spawn to launch distributed processes: the
        # main_worker process function
        mp.spawn(main_worker, nprocs=ngpus_per_node, args=(ngpus_per_node, args))
    else:
        # Simply call main_worker function
        main_worker(args.gpu, ngpus_per_node, args)


def main_worker(gpu, ngpus_per_node, args):
    global best_acc1
    args.gpu = gpu

    if args.gpu is not None:
        print("Use GPU: {} for training".format(args.gpu))

    if args.distributed:
        if args.dist_url == "env://" and args.rank == -1:
            args.rank = int(os.environ["RANK"])
        if args.multiprocessing_distributed:
            # For multiprocessing distributed training, rank needs to be the
            # global rank among all the processes
            args.rank = args.rank * ngpus_per_node + gpu
        dist.init_process_group(backend=args.dist_backend, init_method=args.dist_url,
                                world_size=args.world_size, rank=args.rank)
    # create model

    if RESNET:
        model=resnet.resnet50(pretrained=True)
    else:
        model=vgg.vgg16(pretrained=True)
    if not torch.cuda.is_available():
        print('using CPU, this will be slow')
    else:
        #torch.cuda.set_device(args.gpu)
        model = model.cuda()
        model.eval()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=True,
        num_workers=args.workers, pin_memory=True)

    K=len(method)
    results=np.zeros([K,5])
    model.eval()
    output=0
    import ADGT
    adgt = ADGT.ADGT(use_cuda=True, name='ImageNet')
    if DATASET=='train':
        loader=None
    else:
        loader=val_loader
    if True:
        end = time.time()
        for i, (images, target) in enumerate(loader):
            images, target = images.cuda(), target.cuda()
            with torch.no_grad():
                base=model(images)
                base=F.softmax(base,1)
                top1=torch.argmax(base,1)
            for j,m in enumerate(method):
                print(j, m)
                heatmaps=adgt.pure_explain(images,model,m)
                for t,p in enumerate(percetile):
                        temp=heatmaps
                        temp=F.interpolate(temp,(224,224),mode='bilinear')
                        if MOST_SALIENCY:
                            maskimg = perturb_most(images, temp, int(p))
                        else:
                            maskimg=perturb(images,temp,int(p))
                        with torch.no_grad():
                            out=model(maskimg)
                            out=F.softmax(out,1)
                            iii=torch.arange(images.size(0))

                            #results[j,t]=(results[j,t]*i+torch.sum(torch.abs(out[iii,top1]-base[iii,top1])).item())/(i+1)
                            top_out = torch.argmax(out, 1)
                            results[j, t] = (results[j, t] * i + torch.sum((top_out!=top1).float()).item()) / (i + 1)
            if i%10==0:
                temp=results/BATCHSIZE
                temp=calculate_auc(temp)
                print(temp)
                np.savetxt(os.path.join('result3', NO_INFO,str(RESNET)+str(MOST_SALIENCY)+'_baseline2.csv'), temp, delimiter=',')
                draw(temp[:,5].reshape(1,-1),os.path.join('result3', NO_INFO,str(RESNET)+str(MOST_SALIENCY)+'2.jpg'))
    print(results/16)

def calculate_auc(result):
    temp=0.1*(result.sum(1)*2+0.5*(-result[:,0]+result[:,-2]-result[:,-1])).reshape([-1,1])
    return np.concatenate((result,temp),1)

import math
def get_gaussian_kernel(kernel_size=3, sigma=2, channels=3):
    # Create a x, y coordinate grid of shape (kernel_size, kernel_size, 2)
    x_coord = torch.arange(kernel_size)
    x_grid = x_coord.repeat(kernel_size).view(kernel_size, kernel_size)
    y_grid = x_grid.t()
    xy_grid = torch.stack([x_grid, y_grid], dim=-1).float()

    mean = (kernel_size - 1) / 2.
    variance = sigma ** 2.

    # Calculate the 2-dimensional gaussian kernel which is
    # the product of two gaussian distributions for two different
    # variables (in this case called x and y)
    gaussian_kernel = (1. / (2. * math.pi * variance)) * \
                      torch.exp(
                          -torch.sum((xy_grid - mean) ** 2., dim=-1) / \
                          (2 * variance)
                      )

    # Make sure sum of values in gaussian kernel equals 1.
    gaussian_kernel = gaussian_kernel / torch.sum(gaussian_kernel)

    # Reshape to 2d depthwise convolutional weight
    gaussian_kernel = gaussian_kernel.view(1, 1, kernel_size, kernel_size)
    gaussian_kernel = gaussian_kernel.repeat(channels, 1, 1, 1)

    gaussian_filter = nn.Conv2d(in_channels=channels, out_channels=channels, kernel_size=kernel_size, groups=channels,
                                bias=False, padding=kernel_size // 2)

    gaussian_filter.weight.data = gaussian_kernel
    gaussian_filter.weight.requires_grad = False

    return gaussian_filter
def perturb_most(images,heatmaps,p):
    p=100-p
    heatmaps = heatmaps.sum(1, keepdim=True)
    temp=heatmaps.cpu().numpy()

    pvalue=[]
    for i in range(heatmaps.size(0)):
        t=np.percentile(temp[i],p)
        pvalue.append(t)
    pvalue=torch.Tensor(np.array(pvalue)).to(images).view(-1,1,1,1)
    mask=torch.lt(heatmaps.to(images),pvalue).float()
    #print(torch.sum(mask).item()/torch.sum(torch.ones_like(mask)).item(),p)
    if NO_INFO=='zero':
        zeros=torch.zeros_like(images)
    elif NO_INFO=='noise':
        zeros=torch.randn_like(images)
    elif NO_INFO=='blur':
        blur=get_gaussian_kernel().cuda()
        zeros=blur(images)
    else:
        print('no such uninformative value',NO_INFO)
    return images*mask+zeros*(1-mask)

def perturb(images,heatmaps,p,THIRD=True):
    #heatmaps = torch.abs(heatmaps)
    heatmaps = heatmaps.sum(1, keepdim=True)
    if THIRD:
        temp = heatmaps.cpu().numpy()
    else:
        temp=np.abs(heatmaps.cpu().numpy())

    pvalue=[]
    for i in range(heatmaps.size(0)):
        t=np.percentile(temp[i],p)
        pvalue.append(t)
    pvalue=torch.Tensor(np.array(pvalue)).cuda().view(-1,1,1,1)

    if THIRD:
        mask = torch.gt(heatmaps, pvalue).float()
    else:
        mask = torch.gt(torch.abs(heatmaps), pvalue).float()

    if NO_INFO=='zero':
        zeros=torch.zeros_like(images)
    elif NO_INFO=='noise':
        zeros=torch.randn_like(images)
    elif NO_INFO=='blur':
        blur=get_gaussian_kernel().cuda()
        zeros=blur(images)
    else:
        print('no such uninformative value',NO_INFO)
    return images*mask+zeros*(1-mask)
import matplotlib.pyplot as plt
def draw(data,pth):
    fig=plt.figure()
    ax=fig.add_subplot(111)
    im=ax.imshow(data)#cmap=plt.cm.hot_r
    #plt.colorbar(im)
    plt.xticks([])
    plt.yticks([])
    for  i in range(data.shape[0]):
        for j in  range(data.shape[1]):
            ax.text(j,i,int(data[i,j]*100)/100.0,ha='center',va='center',color='w')
    fig.tight_layout()
    plt.savefig(pth)
    plt.close()
if __name__ == '__main__':
    main()