import argparse
import os
import random
import shutil
import time
import warnings
import json
import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet,vgg
import numpy as np
import torch.nn.functional as F
from PIL import Image
import matplotlib.pyplot as plt
from utils.visualization import save_images5,save_images2,save_images6

STATUS='Poison_final_'
MODEL='resnet50'#'vgg16'#
STATUS=STATUS+MODEL
DATASET='test'#'train'#
PATTERN='cross'#'square'#'two'#
ROOT='result3'
if not os.path.exists(ROOT):
    os.mkdir(ROOT)
method=['InputXGradient','InputXSG','InputXGBP','DeepLIFT','IntegratedGradients']
#method=['DeepLIFT']
ALPHAs=[0,0.3,0.5,0.7,0.9]
SIZE=[2]
POSITION=-1#12#7#2#

torch.set_num_threads(4)
os.environ["CUDA_VISIBLE_DEVICES"] = "7"

def setup_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)
from utils.poison_attack import poisoning_attack
model_names = sorted(name for name in models.__dict__
    if name.islower() and not name.startswith("__")
    and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR',default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                        ' | '.join(model_names) +
                        ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=64, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')



def prepare_img(path):
    means = [0.485, 0.456, 0.406]
    stds = [0.229, 0.224, 0.225]
    img_size = 224

    dirs = os.listdir(path)
    imgs = []
    for fn in dirs:
        img_path = path + '/' + fn
        # img = cv2.imread(img_path, 1)
        # img = np.float32(cv2.resize(img, (img_size, img_size))) / 255
        input_image = Image.open(img_path).convert('RGB')
        preprocess = transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(img_size),
            transforms.ToTensor(),
            transforms.Normalize(mean=means, std=stds),
        ])
        input_tensor = preprocess(input_image)
        img = input_tensor.unsqueeze(0)
        imgs.append(img)
    '''
    imgs = np.array(imgs)

    preprocessed_imgs = imgs.copy()[:, :, :, ::-1]
    for i in range(3):
        preprocessed_imgs[:, :, :, i] = preprocessed_imgs[:, :, :, i] - means[i]
        preprocessed_imgs[:, :, :, i] = preprocessed_imgs[:, :, :, i] / stds[i]
    #preprocessed_imgs=preprocessed_imgs*2-1
    preprocessed_imgs = \
        np.ascontiguousarray(np.transpose(preprocessed_imgs, (0, 3, 1, 2)))
    preprocessed_imgs = torch.from_numpy(preprocessed_imgs)
    '''
    preprocessed_imgs = torch.cat(imgs, 0)
    preprocessed_imgs = preprocessed_imgs.cuda()
    return preprocessed_imgs

def draw(X,pth):
    x=[]
    for m in X:
        temp=m
        #temp=F.relu(temp)
        if temp.size(2)<224:
            #temp=F.interpolate(temp,(224,224),mode='nearest')
            temp = F.interpolate(temp, (224, 224),mode='bilinear')
        temp = temp.sum(1,keepdim=True)
        temp=temp.detach().cpu().numpy()
        high = np.abs(temp).max()
        temp=temp/high
        x.append(temp)
    x=np.concatenate(x,0)
    save_images5(x, pth)

def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    setup_seed(999)
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=False,
        num_workers=args.workers, pin_memory=False)

    main_worker(val_loader,POSITION,SIZE, args)


def main_worker(val_loader,position,size, args):
    # create model
    models=[]
    for k,s in enumerate(size):
        if MODEL=='vgg16':
            models.append(vgg.vgg16(pretrained=True).cuda())
        elif MODEL=='resnet50':
            models.append(resnet.resnet50(pretrained=True).cuda())
        resume = os.path.join('checkpoint',MODEL, PATTERN + str(s) + '.pth.tar')
        if os.path.isfile(resume):
            print("=> loading checkpoint '{}'".format(resume))
            if args.gpu is None:
                checkpoint = torch.load(resume)
            else:
                # Map model to be loaded to specified single gpu.
                loc = 'cuda:{}'.format(args.gpu)
                checkpoint = torch.load(resume, map_location=loc)
            args.start_epoch = checkpoint['epoch']
            best_acc1 = checkpoint['best_acc1']
            if args.gpu is not None:
                # best_acc1 may be from a checkpoint from a different GPU
                best_acc1 = best_acc1.to(args.gpu)
            models[k].load_state_dict(checkpoint['state_dict'])
            print("=> loaded checkpoint '{}' (epoch {})"
                  .format(resume, checkpoint['epoch']))
        else:
            print("=> no checkpoint found at '{}'".format(resume))

        models[k].eval()
    import ADGT, split_model,gc
    adgt = ADGT.ADGT(use_cuda=True, name='ImageNet')

    pth = os.path.join(ROOT, STATUS,PATTERN)
    if not os.path.exists(os.path.join(ROOT, STATUS)):
        os.mkdir(os.path.join(ROOT, STATUS))
    if not os.path.exists(pth):
        os.mkdir(pth)
    img = prepare_img(os.path.join('sanity_checks_saliency', 'data', 'images'))
    img = img.cuda()
    for k, s in enumerate(size):
        net=models[k]
        model_As, model_Bs, feature_size = split_model.prepare_model(net,mode=MODEL)
        #kpth= os.path.join(pth,  str(s))
        #if not os.path.exists(kpth):
        #    os.mkdir(kpth)
        for i in range(2):
            print(i)
            base_img, base_target = poisoning_attack(img[i].unsqueeze(0), torch.zeros(1).cuda().long(),s,pattern=PATTERN)
            #X = split_model.explain_middle_layer_and_raw(base_img, net, model_As, model_Bs, feature_size, method)
            #split_model.visualize_most(X, kpth, alpha=0, prefix=str(i), methods=method)
            #save_images2(base_img.detach().cpu().numpy(), os.path.join(kpth,  str(i) + 'raw.png'))

            kpth = os.path.join(pth, str(i))
            if not os.path.exists(kpth):
                os.mkdir(kpth)
            X = split_model.explain_middle_layer_and_raw(base_img, net, model_As, model_Bs, feature_size, method,
                                                         target=torch.zeros_like(base_target))
            split_model.visualize_most(X, kpth, alpha=0, prefix=str(i), methods=method)
            result = []
            for j in range(0, len(method)):
                x = X[j]
                temp = split_model.visualize_most_alpha(x, kpth, ALPHAs, method=method[j], plot=False)
                result.append(temp)

            # save_images2(base_img.detach().cpu().numpy(), os.path.join(pth,  str(i)+ 'raw.png'))
            save_images6(result, os.path.join(pth, str(i) + 'result.png'))

            if PATTERN=='two':
                kpth = os.path.join(pth, str(i)+'_1')
                if not os.path.exists(kpth):
                    os.mkdir(kpth)
                X = split_model.explain_middle_layer_and_raw(base_img, net, model_As, model_Bs, feature_size, method,
                                                             target=torch.ones_like(base_target))
                split_model.visualize_most(X, kpth, alpha=0, prefix=str(i), methods=method)
                result = []
                for j in range(0, len(method)):
                    x = X[j]
                    temp = split_model.visualize_most_alpha(x, kpth, ALPHAs, method=method[j], plot=False)
                    result.append(temp)

                # save_images2(base_img.detach().cpu().numpy(), os.path.join(pth,  str(i)+ 'raw.png'))
                save_images6(result, os.path.join(pth, str(i) + 'result_1.png'))

            save_images2(base_img.detach().cpu().numpy(), os.path.join(pth, str(i) + 'raw.png'))
        del model_As,model_Bs,feature_size
        gc.collect()






if __name__ == '__main__':
    main()