import argparse
import os
import random
import shutil
import time
import warnings
import json
import torch
import torch.nn as nn
import torch.nn.parallel
import torch.backends.cudnn as cudnn
import torch.distributed as dist
import torch.optim
import torch.multiprocessing as mp
import torch.utils.data
import torch.utils.data.distributed
import torchvision.transforms as transforms
import torchvision.datasets as datasets
import torchvision.models as models
from torch.utils.tensorboard import SummaryWriter
from model import resnet, vgg
import numpy as np
import torch.nn.functional as F
import matplotlib.pyplot as plt
from utils.visualization import save_images, save_images2, save_images4
from split_model import split_model,obtain_relu_num

STATUS = 'Poison_split_'
MODEL = 'vgg16'#'resnet50'  #
STATUS = STATUS + MODEL
DATASET = 'test'  # 'train'#
PATTERN = 'square'  # 'two'#'cross'#
ROOT = 'result2'
if not os.path.exists(ROOT):
    os.mkdir(ROOT)
method=['InputXGradient','SmoothGrad','Guided_BackProp','InputXSG','InputXGBP','DeepLIFT','IntegratedGradients','FullGrad']
#method='InputXGradient'

SIZE = [2]
POSITION = -1  # 12#7#2#

torch.set_num_threads(4)
os.environ["CUDA_VISIBLE_DEVICES"] = "5"


def setup_seed(seed):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)


def poisoning_attack(image, target, size, p=1):
    # mask=1 means poison
    if PATTERN == 'square':
        mask = (torch.rand(image.size(0)).cuda() < p).float()
        target = target * (1 - mask).long()
        poison = image.clone()
        s = int(size * 224 / 7)
        poison[:, :, :s, :s] = 0.5 / 0.225
        mask = mask.view(-1, 1, 1, 1)
        image = image * (1 - mask) + poison * mask
    elif PATTERN == 'cross':
        mask = (torch.rand(image.size(0)).cuda() < p).float()
        target = target * (1 - mask).long()
        poison = image.clone()
        s = int(size * 224 / 7)
        for i in range(s):
            poison[:, :, i, i] = 0
            poison[:, :, i, s - i] = 0
        mask = mask.view(-1, 1, 1, 1)
        image = image * (1 - mask) + poison * mask
    elif PATTERN == 'two':
        target = torch.zeros_like(target)
        target = target.long()
        poison = image.clone()
        s = int(size * 224 / 7)
        poison[:, :, :s, :s] = 0.5 / 0.225
        for i in range(s):
            poison[:, :, 223 - i, 223 - i] = 0
            poison[:, :, 223 - i, 223 - s + i] = 0
        image = poison
    return image, target


model_names = sorted(name for name in models.__dict__
                     if name.islower() and not name.startswith("__")
                     and callable(models.__dict__[name]))

parser = argparse.ArgumentParser(description='PyTorch ImageNet Training')
parser.add_argument('--data', metavar='DIR', default='/data_SSD2/zgh/workspace/data/ImageNet',
                    help='path to dataset')
parser.add_argument('-a', '--arch', metavar='ARCH', default='resnet50',
                    choices=model_names,
                    help='model architecture: ' +
                         ' | '.join(model_names) +
                         ' (default: resnet18)')
parser.add_argument('-j', '--workers', default=4, type=int, metavar='N',
                    help='number of data loading workers (default: 4)')
parser.add_argument('--epochs', default=90, type=int, metavar='N',
                    help='number of total epochs to run')
parser.add_argument('--start-epoch', default=0, type=int, metavar='N',
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch-size', default=64, type=int,
                    metavar='N',
                    help='mini-batch size (default: 256), this is the total '
                         'batch size of all GPUs on the current node when '
                         'using Data Parallel or Distributed Data Parallel')
parser.add_argument('--lr', '--learning-rate', default=0.1, type=float,
                    metavar='LR', help='initial learning rate', dest='lr')
parser.add_argument('--momentum', default=0.9, type=float, metavar='M',
                    help='momentum')
parser.add_argument('--wd', '--weight-decay', default=1e-4, type=float,
                    metavar='W', help='weight decay (default: 1e-4)',
                    dest='weight_decay')
parser.add_argument('-p', '--print-freq', default=10, type=int,
                    metavar='N', help='print frequency (default: 10)')
parser.add_argument('--resume', default='', type=str, metavar='PATH',
                    help='path to latest checkpoint (default: none)')
parser.add_argument('-e', '--evaluate', dest='evaluate', action='store_true',
                    help='evaluate model on validation set')
parser.add_argument('--pretrained', dest='pretrained', action='store_true',
                    help='use pre-trained model')
parser.add_argument('--world-size', default=-1, type=int,
                    help='number of nodes for distributed training')
parser.add_argument('--rank', default=-1, type=int,
                    help='node rank for distributed training')
parser.add_argument('--dist-url', default='tcp://224.66.41.62:23456', type=str,
                    help='url used to set up distributed training')
parser.add_argument('--dist-backend', default='nccl', type=str,
                    help='distributed backend')
parser.add_argument('--seed', default=None, type=int,
                    help='seed for initializing training. ')
parser.add_argument('--gpu', default=None, type=int,
                    help='GPU id to use.')
parser.add_argument('--multiprocessing-distributed', action='store_true',
                    help='Use multi-processing distributed training to launch '
                         'N processes per node, which has N GPUs. This is the '
                         'fastest way to use PyTorch for either single node or '
                         'multi node data parallel training')


def main():
    args = parser.parse_args()

    if args.seed is not None:
        random.seed(args.seed)
        torch.manual_seed(args.seed)
        cudnn.deterministic = True
        warnings.warn('You have chosen to seed training. '
                      'This will turn on the CUDNN deterministic setting, '
                      'which can slow down your training considerably! '
                      'You may see unexpected behavior when restarting '
                      'from checkpoints.')

    if args.gpu is not None:
        warnings.warn('You have chosen a specific GPU. This will completely '
                      'disable data parallelism.')

    if args.dist_url == "env://" and args.world_size == -1:
        args.world_size = int(os.environ["WORLD_SIZE"])

    args.distributed = args.world_size > 1 or args.multiprocessing_distributed

    ngpus_per_node = torch.cuda.device_count()

    cudnn.benchmark = True

    traindir = os.path.join(args.data, 'train')
    valdir = os.path.join(args.data, 'val')
    normalize = transforms.Normalize(mean=[0.485, 0.456, 0.406],
                                     std=[0.229, 0.224, 0.225])
    '''
    train_dataset = datasets.ImageFolder(
        traindir,
        transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ]))
    if args.distributed:
        train_sampler = torch.utils.data.distributed.DistributedSampler(train_dataset)
    else:
        train_sampler = None
    train_loader = torch.utils.data.DataLoader(
        train_dataset, batch_size=args.batch_size, shuffle=(train_sampler is None),
        num_workers=args.workers, pin_memory=True, sampler=train_sampler)
    '''
    setup_seed(999)
    val_loader = torch.utils.data.DataLoader(
        datasets.ImageFolder(valdir, transforms.Compose([
            transforms.Resize(256),
            transforms.CenterCrop(224),
            transforms.ToTensor(),
            normalize,
        ])),
        batch_size=args.batch_size, shuffle=False,
        num_workers=args.workers, pin_memory=False)

    main_worker(val_loader, POSITION, SIZE, args)


def main_worker(val_loader, position, size, args):
    # create model
    for k, s in enumerate(size):
        if MODEL == 'vgg16':
            model=vgg.vgg16(pretrained=True).cuda()
        elif MODEL == 'resnet50':
            models=resnet.resnet50(pretrained=True).cuda()
        resume = os.path.join('checkpoint', MODEL, PATTERN + str(s) + '.pth.tar')
        if os.path.isfile(resume):
            print("=> loading checkpoint '{}'".format(resume))
            if args.gpu is None:
                checkpoint = torch.load(resume)
            else:
                # Map model to be loaded to specified single gpu.
                loc = 'cuda:{}'.format(args.gpu)
                checkpoint = torch.load(resume, map_location=loc)
            args.start_epoch = checkpoint['epoch']
            best_acc1 = checkpoint['best_acc1']
            if args.gpu is not None:
                # best_acc1 may be from a checkpoint from a different GPU
                best_acc1 = best_acc1.to(args.gpu)
            model.load_state_dict(checkpoint['state_dict'])
            print("=> loaded checkpoint '{}' (epoch {})"
                  .format(resume, checkpoint['epoch']))
        else:
            print("=> no checkpoint found at '{}'".format(resume))

    model.eval()
    L = obtain_relu_num(model)
    model_As = []
    model_Bs = []
    feature_size = []
    for i in range(1, L - 2):
        A, B, W = split_model(model, i)
        model_As.append(A)
        model_Bs.append(B)
        feature_size.append(W)
    import ADGT
    adgt = ADGT.ADGT(use_cuda=True, name='ImageNet')
    if DATASET == 'train':
        loader = None
    else:
        loader = val_loader
    pth = os.path.join(ROOT, STATUS, PATTERN)
    if not os.path.exists(os.path.join(ROOT, STATUS)):
        os.mkdir(os.path.join(ROOT, STATUS))
    if not os.path.exists(pth):
        os.mkdir(pth)
    if True:
        for i, (images, target) in enumerate(loader):
            for j in range(64):
                if i * 64 + j == 26946 or i * 64 + j == 48510:
                    images, target = images.cuda(), target.cuda()

                    base_img, base_target = poisoning_attack(images, target, SIZE[0])
                    base_img = base_img[j].unsqueeze(0)
                    result = []
                    for m in method:
                        result.append([])
                    for n in range(len(model_As) + 1):
                        if n == 0:
                            for k, m in enumerate(method):
                                print(i, j, n, m)
                                grad = adgt.pure_explain(base_img, model, m)
                                temp = grad.sum(1, keepdim=True)
                                maxx, _ = temp.view(temp.size(0), -1).abs().max(1)
                                temp = temp / maxx
                                temp = temp.detach()
                                result[k].append(temp)
                                # save_images3(grad.detach().cpu().numpy(), os.path.join(img_pth, m+str(j)+'_'+str(n)+ '.png'))
                        else:
                            # print(model_As[n-1])
                            width = feature_size[n - 1]
                            M = model_As[n - 1](base_img)
                            H = int(np.sqrt(M.size(1) / width))
                            M = M.view(M.size(0), width, H, H)
                            for k, m in enumerate(method):
                                print(i, j, n, m)
                                grad = adgt.pure_explain(M, model_Bs[n - 1], m)
                                temp = grad.sum(1, keepdim=True)
                                temp = F.interpolate(temp, [224, 224], mode='nearest')
                                maxx, _ = temp.view(temp.size(0), -1).abs().max(1)
                                temp = temp / maxx
                                temp = temp.detach()
                                result[k].append(temp)

                    visualize(result,os.path.join(pth, str(i*64+j) +'_'+str(SIZE[0])+ '_split.png'))

                    save_images2(base_img.detach().cpu().numpy(),
                                     os.path.join(pth, str(i * 64 + j) + '_' + str(SIZE[0]) + 'raw.png'))


def visualize(X,save_pth,size=224,layer_num=12):
    fig = plt.figure()
    T=len(X)
    N=layer_num
    for i in range(N):
        for j in range(T):
            temp=X[j][i]
            #temp=temp.unsqueeze(0)
            temp = F.interpolate(temp, size=(size,size),
                                 mode='bilinear')
            temp=temp.sum(1).squeeze().cpu().numpy()
            plt.subplot(T, N, j*N+i+1)
            ax = fig.add_subplot(T, N, j*N+i+1)
            ax.set_xticks([])
            ax.set_yticks([])
            img = temp
            plt.imshow(img, cmap="seismic")
            high = np.abs(temp).max()
            plt.clim(-high, high)

    plt.gcf().set_size_inches(size*N / 100,  size*T/ 100)
    plt.subplots_adjust(top=0.99, bottom=0.01, right=0.99, left=0.01, hspace=0.05, wspace=0.05)
    plt.savefig(save_pth)
    plt.close()


if __name__ == '__main__':
    main()