# PointCloudAutoencoder

<p align="center">
    <img src="figures/figure_1.png" alt="framework" width="100%" />
</p>

This repository contains the code for Point Cloud Autoencoder model proposed in the paper "Deterministic Strided and Transposed Convolutions for Point Clouds Operating Directly on the Points." The architecture details can be found in the paper itself. 
The paper associated with this repository is currently under review for presentation at NeurIPS 2023.

## Setup Code
The code is built on PyTorch. Make sure to have PyTorch installed before running the code. Instructions for installing [PyTorch](https://pytorch.org/) can be found at the provided link.
```bash
python -m pip install torch
```
In addition to PyTorch, the repository also requires the installation of the [KNN_CUDA](https://github.com/unlimblue/KNN_CUDA) library. The library is used for efficient k-nearest neighbor operations in CUDA. The provided instructions explain how to install KNN_CUDA and include the necessary commands:

```bash
pip install --upgrade https://github.com/unlimblue/KNN_CUDA/releases/download/0.2/KNN_CUDA-0.2-py3-none-any.whl
wget -P /usr/bin https://github.com/unlimblue/KNN_CUDA/raw/master/ninja
```

## Setup Datasets
The repository supports two datasets: ModelNet40 and Kitti3D. Detailed instructions are given below to set up these datasets for training and testing.

ModelNet40
```bash
wget -P data --no-check-certificate https://shapenet.cs.stanford.edu/media/modelnet40_normal_resampled.zip
unzip data/modelnet40_normal_resampled.zip -d data
python data_utils/ModelNetDataLoader.py
```

Kitti3D
* Download the official [KITTI 3D object detection](http://www.cvlibs.net/datasets/kitti/eval_object.php?obj_benchmark=3d) dataset
* Clone [TearingNet](https://github.com/InterDigitalInc/TearingNet) and use their script for building the dataset:

> * Our KITTI Multi-Object (KIMO) Dataset is constructed with <a href=https://github.com/3bobo/PCDet/blob/95d2ab5e9c9acf8e9de8eba0d31fb161fc30221b/pcdet/datasets/kitti/kitti_dataset.py target="_blank">kitti_dataset.py</a> of <a href=https://github.com/3bobo/PCDet/tree/95d2ab5e9c9acf8e9de8eba0d31fb161fc30221b target="_blank">PCDet (commit 95d2ab5)</a>. Please clone and install <a href=https://github.com/3bobo/PCDet/tree/95d2ab5e9c9acf8e9de8eba0d31fb161fc30221b target="_blank">PCDet</a>, then prepare the KITTI dataset according to their instructions.
> * Assume the name of the cloned folder is ``PCDet``, please replace the ``create_groundtruth_database()`` function in ``kitti_dataset.py`` by our modified one provided in ``TearingNet/util/pcdet_create_grouth_database.py``.
> * Prepare the KITTI dataset, then generate the data infos according to the instructions in the <a href=https://github.com/3bobo/PCDet/tree/95d2ab5e9c9acf8e9de8eba0d31fb161fc30221b#readme target="_blank">README.md</a> of <a href=https://github.com/3bobo/PCDet/tree/95d2ab5e9c9acf8e9de8eba0d31fb161fc30221b target="_blank">PCDet</a>.
> ** Create the folders ``TearingNet/dataset`` and ``TearingNet/dataset/kittimulobj`` then put the newly-generated folder ``PCDet/data/kitti/kitti_single`` under ``TearingNet/dataset/kittimulobj``. Also, put the newly-generated file ``PCDet/data/kitti/kitti_dbinfos_object.pkl`` under the ``TearingNet/dataset/kittimulobj`` folder.
> * Instead of assembling several single-object point clouds together and write down as a multi-object point cloud, we generate the parameters that parameterize the multi-object point clouds then assemble them on the fly during training/testing. To obtain the parameters, run our prepared scripts as follows under the ``TearingNet`` folder. These scripts generate the training and testing splits of the KIMO-5 dataset:
> ```
> ./scripts/launch.sh ./scripts/gen_data/gen_kitti_mulobj_train_5x5.sh
> ./scripts/launch.sh ./scripts/gen_data/gen_kitti_mulobj_test_5x5.sh
> ```
> * The file structure of the KIMO dataset after these steps becomes:
> ```
> kittimulobj
>       ├── kitti_dbinfos_object.pkl
>       ├── kitti_mulobj_param_test_5x5_2048.pkl
>       ├── kitti_mulobj_param_train_5x5_2048.pkl
>       └── kitti_single
>               ├── 0_0_Pedestrian.bin
>               ├── 1000_0_Car.bin
>               ├── 1000_1_Car.bin
>               ├── 1000_2_Van.bin
>               ...
> ```

## Start Training
<p align="center">
    <img src="figures/figure_4.png" alt="framework" width="100%" />
</p>
This repository includes a train.py script for training the autoencoder model. The script accepts command-line arguments for various options, such as the dataset, model, batch size, number of nearest neighbors, ablation factors, and codeword channels. Examples of training commands are provided to illustrate how to use the script with different configurations.
A command-line help command is provided to summarize all available options and arguments for the train.py script:

```bash
$ python train.py --help
cuda
usage: train.py [-h] [-d DATASET] [-m MODEL] [-b BATCH_SIZE] [-k N_KNN]
                [-f MODEL_FILE] [-e EPOCH] [-a ABLATION [ABLATION ...]]
                [-cc CODEWORD_CHANNELS]

Parses command.

options:
  -h, --help            show this help message and exit
  -d DATASET, --dataset DATASET
                        The dataset used.
  -m MODEL, --model MODEL
                        The model used.
  -b BATCH_SIZE, --batch_size BATCH_SIZE
                        The batch size.
  -k N_KNN, --n_knn N_KNN
                        The number of nearest neighbors processed in one
                        knn_conv.
  -f MODEL_FILE, --model_file MODEL_FILE
                        The location of the saved model.
  -e EPOCH, --epoch EPOCH
                        The epoch to start with.
  -a ABLATION [ABLATION ...], --ablation ABLATION [ABLATION ...]
                        The decrease and increase factors
  -cc CODEWORD_CHANNELS, --codeword_channels CODEWORD_CHANNELS
                        The number of channels in the codeword.
```

Training can be done e.g. on the Kimo6 data set using the following command:
```bash
python train.py --model own --dataset kitti6 -b 64
```
This command will train the default model with a batch-size of 64. If one wants to increase the number of code-words to e.g. 128, ablation to (14,8), and kNN to 16, execute the follwoing command:
```bash
python train.py --model own --dataset kitti6 -b 64 -cc 128 -a 14 8 8 14 -k 16
```

Have fun! :-)