# Hyper-parameter Settings

This file provides a concise overview of hyper-parameter settings for benchmark experiments on UCI datasets, CIFAR-10, and CelebA.

---

## UCI Benchmarks

Below are the hyper-parameter settings for models evaluated on UCI datasets:

#### Shared Hyper-parameters
*   **Optimizer**: Adam.
*   **MLP Activation**: SiLU.
*   **MLP Hidden Layers**: The General MLP Architecture (3 layers x 1024 units) is assumed.

### MIRI

```yaml
max_rounds: 10
batch_size: 256
max_epochs: 10000
ode_steps: 1000
learning_rate: 1e-6
```

### GAIN

```yaml
n_epochs: 10000
batch_size: 256
hint_rate: 0.9
loss_alpha: 10.0
learning_rate: 1e-6
```

### MissDiff

```yaml
n_epochs: 10000
n_iter: 1000
batch_size: 256
learning_rate: 1e-6
n_samples: 1
```

### KnewImp

```yaml
entropy_reg: 10.0
bandwidth: 1
score_net_epoch: 10000
niter: 10
initializer: null
lr: 1e-6
clamp: false
```

### TabCSDI

```yaml
n_epochs: 10000
n_iter: 1000
n_samples: 1
batch_size: 256
learning_rate: 1e-6
```

### HyperImpute & MICE
Default settings as defined in the [HyperImpute](https://github.com/vanderschaarlab/hyperimpute) repository.

---

## Image Benchmarks (CIFAR-10 & CelebA)

The following settings apply to all CIFAR-10 and CelebA experiments:

#### Shared Hyper-parameters
*   **Optimizer**: Adam.
*   **CNN Activation**: ReLU.
*   **CNN Hidden Layers**: The General CNN Architecture (Initial Conv to 64 channels, 4 ResBlocks x 64 channels, Final Conv to output channels) is assumed.

### MIRI

```yaml
max_rounds: 15
batch_size: 500
max_epochs: 900
ode_steps: 100
learning_rate: 1e-2
```

### GAIN

```yaml
n_epochs: 10000
batch_size: 64
hint_rate: 0.9
loss_alpha: 10.0
learning_rate: 1e-3
```

### KnewImp

```yaml
entropy_reg: 10.0
bandwidth: 1
score_net_epoch: 100
niter: 5
lr: 1e-1
score_net_lr: 1e-3
clamp: true
```

### MissDiff

```yaml
n_epochs: 100
n_iter: 100
batch_size: 500
inference_batch_size: 500
learning_rate: 1e-2
n_samples: 5
```

### HyperImpute
Default settings as defined in the [HyperImpute](https://github.com/vanderschaarlab/hyperimpute) repository.