
# Dependencies
```
conda env create -f environment.yml
conda activate feature_selection
```

# Download checkpoints

* [Download](https://drive.google.com/file/d/14T1D0ejG677pVwgFTRkMMVDgpa_wqyAM/view?usp=sharing) and extract pretrained weights data samples into project root.

# Download data

```
mkdir -p data/coco_subsets

cd data/coco_subsets
wget http://images.cocodataset.org/zips/val2017.zip
wget http://images.cocodataset.org/zips/train2017.zip

unzip train2017.zip  # Extract archieve
unzip val2017.zip    # Extract archieve
cd -                 # Get back to project root
```

Note: for full reprodusibility also download `docvqa` and `chart_qa_images` datasets for data generation scripts.


# InternVL3

## Demo
* `./InternVL3/demo/notebook_image.ipynb` - image feature selection demo notebook
* `./InternVL3/demo/notebook_video.ipynb` - video feature selection demo notebook

## Genrate training data

```
cd  InternVL3/code/dataset_generation/
python dataset.py --mode train
python dataset.py --mode val
```

## Training

```bash
cd InternVL3/code/train
python train.py --n_gpu 1
```

Training checkpoints will be saved by default in `./checkpoints`. Training samples vill be saved in `./samples`. Checkout `python train.py --help` to override default params.


# Lui-LLaVa-Next

## Demo
* `./Liu-LLaVA-Next/demo/notebook.ipynb` - feature selection demo notebook
* `./Liu-LLaVA-Next/demo/video_notebook.ipynb` - video feature selection demo notebook

## Genrate training data

```
cd Liu-LLaVA-Next/code/dataset_generation
python dataset.py --mode train
python dataset.py --mode val
```

## Training

```bash
cd Liu-LLaVA-Next/code/train
python train.py --n_gpu 1
```

Training checkpoints will be saved by default in `./checkpoints`. Training samples vill be saved in `./samples`. Checkout `python train.py --help` to override default params.


---

