#!/bin/bash

#SBATCH --job-name=CTF_weather_practical_forward_fill
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --time=0-12:00:00
#SBATCH --mem=32G
#SBATCH --cpus-per-task=4
#SBATCH --partition=P2
#SBATCH --output=/home/s2/hyungjinpark/Practical_baseline/log/CTF/S-%x.%j.out

eval "$(conda shell.bash hook)"

export CUDA_VISIBLE_DEVICES=0

model_name=ChannelTokenFormer
des='ChannelTokenFormer-M'
dataset='weather_practical_train_forward_fill_test_forward_fill_full'

batch_size=(32)
pred_len=(144 288 576 864)
seq_len=(144)
num_heads=(8)
learning_rate=(0.01)
d_model=(128)
d_ff_ratio=(1)
e_layers=(2)
seed=(2021)

for rs in "${seed[@]}"; do
    for bs in "${batch_size[@]}"; do
        for pl in "${pred_len[@]}"; do
            for sl in "${seq_len[@]}"; do
                for nh in "${num_heads[@]}"; do
                    for lr in "${learning_rate[@]}"; do
                        for dm in "${d_model[@]}"; do
                            for dfr in "${d_ff_ratio[@]}"; do
                                for el in "${e_layers[@]}"; do

                                    echo "================================================"
                                    echo "batch_size: $bs"
                                    echo "d_model: $dm"
                                    echo "d_ff: $(($dm * $dfr))"
                                    echo "num_heads: $nh"
                                    echo "seq_len: $sl"
                                    echo "pred_len: $pl"
                                    echo "learning_rate: $lr"
                                    echo "model_name: $model_name"
                                    echo "seed: $rs"
                                    echo "================================================"

                                    python -u /home/s2/hyungjinpark/Practical_baseline/run.py \
                                    --task_name long_term_forecast \
                                    --is_training 1 \
                                    --root_path /shared/s2/lab01/timeSeries/forecasting/base/weather/ \
                                    --data_path $dataset.csv \
                                    --model_id $dataset'_'$sl'_'$pl \
                                    --model $model_name \
                                    --data $dataset \
                                    --features M \
                                    --seq_len $sl \
                                    --label_len 48 \
                                    --pred_len $pl \
                                    --e_layers $el \
                                    --d_layers 1 \
                                    --factor 3 \
                                    --enc_in 21 \
                                    --dec_in 21 \
                                    --c_out 21 \
                                    --des $des \
                                    --d_model $dm \
                                    --d_ff $(($dm * $dfr)) \
                                    --n_heads $nh \
                                    --learning_rate $lr \
                                    --attention_map 0 \
                                    --batch_size $bs \
                                    --patch_lens 12 36 12 12 24 12 12 12 12 12 12 72 72 48 48 6 72 72 72 12 72\
                                    --sampling_rates 3 1 3 3 1.5 3 3 3 3 3 3 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 3 0.5\
                                    --num_global_tokens 3 \
                                    --ind_glb 1 \
                                    --self_temp 1 \
                                    --use_norm 1 \
                                    --keep_prob 1 \
                                    --drop_rate 0 \
                                    --drop_path 0 \
                                    --fix_seed $rs \
                                    --itr 1
                                done
                            done
                        done
                    done
                done
            done
        done
    done
done