import torch.nn as nn 

class GraphConv(nn.Module):
    def __init__(self, input_dim, output_dim, conv):
        super().__init__()
        self.input_dim = input_dim
        self.output_dim = output_dim
        self.conv = conv
        self.linear = nn.Linear(input_dim , output_dim)

    def forward(self, x, batch, t):
        x = self.conv(x, batch, t)
        x = self.linear(x)
        return x