# Contents

- [Install requirements](#install-requirements)
- [Train Superencoders](#train-superencoders)
- [Evaluation on Synthetic Datasets](#evaluation-on-synthetic-datasets)
- [Evaluation on Downstream Tasks](#evaluation-on-downstream-tasks)
  * [QML](#qml)
  * [HHL](#hhl)
- [Figures](#figures)
  * [Runtime of AAE](#runtime-of-aae)
  * [Loss Convergence](#loss-convergence)
  * [Loss Landscape](#loss-landscape)
  * [Evaluation on real devices](#evaluation-on-real-devices)


# Install requirements

```bash
pip install -r requirements.txt
```

To plot figures, requires latex installed, we use matplotlib==3.8.2

```
sudo apt-get install dvipng texlive-latex-extra texlive-fonts-recommended cm-super
```

# Train Superencoders

We use omegaconf as configuration system, configurations for different versions can be found in [`configs/`](https://anonymous.4open.science/r/SuperEncoder-A733/configs)

```bash
python train_superencoder.py <name-of-config-file>
```

The main model we used for evaluation is trained by

```bash
# 4-qubit
python train_superencoder.py configs/v0.0.7.yaml

# 6-qubit
python train_superencoder.py configs/v0.0.7.15.yaml

# 8-qubit
python train_superencoder.py configs/v0.0.7.16.yaml
```

This repository already contains pre-trained models under the directory of `trained_models`, you could also use them directly for evaluation.

# Evaluation on Synthetic Datasets

Table 3.

```bash
python scripts/eval_SuperEncoder_on_datasets.py configs/v0.0.7.yaml
```


# Evaluation on Downstream Tasks


## QML

```bash
python train_qnn.py configs/train_qnn.yaml
```


## HHL

1. Generate state vectors prepared by different QSP.

```bash
python scripts/generate_state_for_hhl.py <superencoder | AAE>
```

The outputs are saved in `data_hhl`, named as `<distribution-name>_<QSP>.txt`.

1. Run HHL evaluation script

> note that currently the HHL algorithm is written in an older version of qiskit, so you need to create a new env to run this script, details can be found in the comments of `scripts/eval_hhl.py`

```bash
python scripts/eval_hhl.py <path-to-target-state>
```

E.g.,

```bash
python scripts/eval_hhl.py data_hhl/beta_a1b1_4-qubits_orig.txt
```

# Figures

## Runtime of AAE

```bash
python scripts/eval_AAE.py configs/AAE_encoder_4qubits.yaml
python scripts/eval_AAE.py configs/AAE_encoder_6qubits.yaml
python scripts/eval_AAE.py configs/AAE_encoder_8qubits.yaml
```

Note that the runtime of QNN ansatz is seperately estimated by

```bash
python train_qnn.py configs/train_qnn_for_infer_time.yaml
python train_qnn.py configs/train_qnn_6qubits_for_infer_time.yaml
python train_qnn.py configs/train_qnn_8qubits_for_infer_time.yaml
```

The runtime for each sample is printed to the terminal.

To generate the figure (you might need to replace the data with ones you measured)

```bash
python scripts/plot_qml_aae_occupation.py
```

## Loss Convergence

Fig. 5

```bash
python scripts/plot_mnist_loss_comparison.py
python scripts/plot_fractaldb_loss_comparison.py
```


## Loss Landscape

Fig. 6

```bash
python scripts/draw_landscape_on_MNIST_mse.py
python scripts/draw_landscape_on_MNIST_state_mse.py
python scripts/draw_landscape_on_MNIST_state_fidelity.py
```

## Evaluation on real devices

We provide the corresponding scripts in `scripts/eval_on_real_devices/` with a separate readme, note that you need an activate IBM cloud account and the associated credentials.


The script to plot Fig. 7 is

```bash
python scripts/plot_circ_depth_fidelity_real_machine.py
```
