"""
This script hard-codes the results of circuit depth and fidelity results on real devices
Detailed instruction and scripts to reproduce these results need to be added later
"""

import matplotlib.pyplot as plt

################# Matplotlib Global Conf #########################
fontsize = 25

plt.rcParams["text.usetex"] = True
plt.rcParams["xtick.labelsize"] = fontsize - 2
plt.rcParams["ytick.labelsize"] = fontsize - 2
# plt.rcParams['ztick.labelsize'] = fontsize - 2
# plt.rcParams["xtick.major.pad"] = -1
# plt.rcParams["ytick.major.pad"] = -1
plt.rcParams["axes.labelsize"] = fontsize
plt.rcParams["axes.labelweight"] = "bold"
## below not working
# plt.rcParams["patch.edgecolor"] = "black"
# plt.rcParams["patch.linewidth"] = 1

################# Matplotlib Global Conf #########################


list_num_qubits = [4, 6, 8]
list_depth_aae = [24, 60, 120]
list_depth_ae = [48, 240, 984]

list_fid_ae = [0.958017, 0.659637, 0.004925]
# list_fid_ae = [0.958017, 0.659637, 0.004925, 0.000061, 0.00000]
list_fid_aae = [0.809082, 0.537354, 0.445593]
list_fid_superencoder = [0.790033, 0.594328, 0.383684]

############# depth ####################
plt.figure(figsize=(6, 4))
plt.bar(
    [x - 0.2 for x in list_num_qubits],
    list_depth_ae,
    width=0.4,
    label="AE",
    edgecolor="black",
    linewidth=1,
)
plt.bar(
    [x + 0.2 for x in list_num_qubits],
    list_depth_aae,
    width=0.4,
    label="AAE/SuperEncoder",
    edgecolor="black",
    linewidth=1,
)
plt.xlabel("Number of Qubits")
plt.ylabel("Circuit Depth")
# plt.title('Depth Comparison')
plt.xticks(list_num_qubits)
plt.yticks([0, 250, 500, 750, 1000])
plt.legend(fontsize=fontsize - 6)
plt.tight_layout()
plt.savefig("depth_comp.pdf")

########### fidelity ################
plt.figure(figsize=(6, 4))
plt.bar(
    [x - 0.2 for x in list_num_qubits],
    list_fid_ae,
    width=0.2,
    label="AE",
    edgecolor="black",
    linewidth=1,
)
plt.bar(
    list_num_qubits,
    list_fid_aae,
    width=0.2,
    label="AAE",
    edgecolor="black",
    linewidth=1,
)
plt.bar(
    [x + 0.2 for x in list_num_qubits],
    list_fid_superencoder,
    width=0.2,
    label="SuperEncoder",
    edgecolor="black",
    linewidth=1,
)
# plt.text(list_num_qubits[2] - 0.4, list_fid_ae[2] + 0.05, f"{list_fid_ae[2]:.4f}", color='red')
plt.annotate(
    f"{list_fid_ae[2]:.4f}",
    xy=(list_num_qubits[2] - 0.2, list_fid_ae[2]),
    xytext=(list_num_qubits[2] - 0.7, list_fid_ae[2] + 0.1),
    arrowprops=dict(facecolor="red", arrowstyle="<-"),
    fontsize=fontsize - 8,
)
plt.xlabel("Number of Qubits")
plt.ylabel("Fidelity")
# plt.title('Fidelity Comparison')
plt.xticks(list_num_qubits)
plt.yticks([0, 0.25, 0.5, 0.75, 1.0])
plt.legend(fontsize=fontsize - 6)
plt.tight_layout()
plt.savefig("fid_comp_real_device.pdf")
