import matplotlib.pyplot as plt
import numpy as np

################# Matplotlib Global Conf #########################
fontsize = 25

plt.rcParams["text.usetex"] = True
plt.rcParams["xtick.labelsize"] = fontsize - 2
plt.rcParams["ytick.labelsize"] = fontsize - 2
# plt.rcParams['ztick.labelsize'] = fontsize - 2
# plt.rcParams["xtick.major.pad"] = -1
# plt.rcParams["ytick.major.pad"] = -1
plt.rcParams["axes.labelsize"] = fontsize
plt.rcParams["axes.labelweight"] = "bold"
## below not working
# plt.rcParams["patch.edgecolor"] = "black"
# plt.rcParams["patch.linewidth"] = 1

################# Matplotlib Global Conf #########################

# cat logs/eval/qnn_forward/qnn_forward.txt | grep "forward time" | awk '{print $NF}' | awk 'BEGIN{sum=0;cnt=0}{sum+=$0;cnt+=1}END{print sum/cnt}'
num_qubit_list = [4, 6, 8]
qnn_time_list = [0.039707, 0.057343, 0.0978168]

# cat logs/eval/aae_fidelity/8qubits.txt
aae_time_list = [5.0086, 20.181015200381808, 59.419353025998134]


# normalization
total_times = np.array(qnn_time_list) + np.array(aae_time_list)
normalized_qnn_time_list = np.array(qnn_time_list) / total_times
normalized_aae_time_list = np.array(aae_time_list) / total_times


plt.figure(figsize=(6, 4))
plt.bar(
    num_qubit_list,
    normalized_qnn_time_list,
    width=1.2,
    label=r"$T_{\mathrm{total}} - T_{\mathrm{AAE}}$",
    color="b",
    alpha=0.7,
    edgecolor="black",
    linewidth=1,
)
bar_aae = plt.bar(
    num_qubit_list,
    normalized_aae_time_list,
    width=1.2,
    bottom=normalized_qnn_time_list,
    label=r"$T_{\mathrm{AAE}}$",
    color="r",
    alpha=0.7,
    edgecolor="black",
    linewidth=1,
)

# display occupation
for bar, value in zip(bar_aae, normalized_aae_time_list):
    # plt.text(bar.get_x() + bar.get_width() / 2, bar.get_height() / 2, "{:.2%}".format(value) + "\\%", ha='center', va='bottom', fontsize=fontsize-4)
    value *= 100
    value = f"{value:.2f}"
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() / 2,
        f"{value}" + "\\%",
        ha="center",
        va="bottom",
        fontsize=fontsize - 4,
    )

plt.xlabel("Number of Qubits", fontsize=20)
plt.ylabel("Normalized Time", fontsize=20)
# plt.title('QNN Time vs AAE Time', fontsize=25)
plt.xticks(num_qubit_list, fontsize=15)
plt.yticks([0, 0.25, 0.5, 0.75, 1.0], fontsize=fontsize - 4)
plt.legend(fontsize=fontsize - 4)

# plt.grid(axis="y")
plt.tight_layout()
plt.savefig("qml_aae_occupation.pdf")
