# Setup

Fork this repository or create a new development branch. Recommend to use VS Code for [remote development](#vs-code).


## Fork

1. click the `Fork` icon on the right top of the github page.
2. Specify a new remote upstream repository that will be synced with the fork.

```bash
git remote add upstream https://github.com/Zhaoyilunnn/qenc.git
```

*Reference*
- https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/configuring-a-remote-repository-for-a-fork


## Dev branch

```
git clone https://github.com/Zhaoyilunnn/qenc.git

# Suggest to follow a <name-dev> fashion to name your branch, e.g., "zhaoyilun-dev"
git checkout -b <your-dev-branch-name>
git push --set-upstream origin <your-dev-branch-name>
```


# Development

1. Develop your superencoder model under `models` submodule.
2. Update `train_superencoder.py` to support your model using `--model` option.
3. Rerun `run.sh`

```
bash -x run.sh <version> <model-name>

# More usage details can be found via
bash run.sh -h
```

4. Check the results.

```
cat logs/qnn/<version>/<model-name>/test_acc.txt
```

*Note*
- Update "[Versions](https://github.com/Zhaoyilunnn/qenc?tab=readme-ov-file#versions)" in README if your model utilize a new paradigm.
- Record the test set accuracy in "[Results](https://github.com/Zhaoyilunnn/qenc?tab=readme-ov-file#results)".



# Pull Request

## Fork

```bash
git fetch upstream
git merge upstream/master

# Fix conflict if there's any
git add .
# Clean format
pre-commit
git add .
git commit -m <commit-message>
git push

# Open your forked repo in github
# Click "Contribute" icon and open a pull request
```


## Branch

```bash
git fetch
git merge master

# Fix conflict if there's any
git add .
# Clean format
pre-commit
git add .
git commit -m <commit-message>
git push

# Open your branch in github
# Click "Contribute" icon and open a pull request
```


*Note*
- Recommend to follow [commit-convension](https://www.conventionalcommits.org/en/v1.0.0/) to format your commit message
- Recommend to run `bash format.sh` before commit.


# Misc
- If your implementation depends on new packages, please update `requirements.txt`
- Recommend not to develop in jupyter notebook. Prefer to create demo/tutorials using notebook.


# VS Code

1. Connect to remote host.

![step_01](https://github.com/Zhaoyilunnn/qenc/assets/40353317/6b88a8e4-8fd5-44c0-84db-06ab1279412e)


![step_02](https://github.com/Zhaoyilunnn/qenc/assets/40353317/354c1f4a-3c4d-4285-bc69-a9b42227e770)

2. Connect to existing containers on the host.

![step_03](https://github.com/Zhaoyilunnn/qenc/assets/40353317/dc5801a2-60af-4b6f-b4ca-83076c348dfd)

![step_04](https://github.com/Zhaoyilunnn/qenc/assets/40353317/f8510bcd-efe1-4eb1-9851-cc3adfa9ee13)
