#!/bin/bash

#SBATCH --account=usr_account
#SBATCH --cpus-per-task=4
#SBATCH --gres=gpu:1
#SBATCH --mem=40G
#SBATCH --time=23:59:00
#SBATCH --output=./slurm_out/slot-attention-%j.out
#SBATCH --error=./slurm_err/slot-attention-%j.err

source /home/usr/env/bin/activate

export WANDB_API_KEY=YOUR_API_KEY
wandb login

export WANDB_MODE=offline


# ------------------------------------------------------------------------------------- #
# ------------------------------------------------------------------------------------- #
# --------------------------------- SPARSE CLEVR RUNS --------------------------------- #
# ------------------------------------------------------------------------------------- #
# ------------------------------------------------------------------------------------- #

# ------------------------------------------------ #
# -------------------- n_balls=2 ----------------- #
# ------------------------------------------------ #


# training from scratch (x,y,c) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyc/cube" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","c"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,c) (sphere only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyc/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","c"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,l) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyl/cube" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","l"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,l) (sphere only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyl/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","l"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,c,p) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xycp/" datamodule.start_idx.train=0 datamodule.num_samples.train=2000 datamodule.start_idx.valid=2000 datamodule.num_samples.valid=500 datamodule.start_idx.test=2500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=4 datamodule.dataset.properties_list=["x","y","c","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,s,p) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xysp/" datamodule.start_idx.train=0 datamodule.num_samples.train=3000 datamodule.start_idx.valid=3000 datamodule.num_samples.valid=500 datamodule.start_idx.test=3500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=4 datamodule.dataset.properties_list=["x","y","s","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# training from scratch (x,y,c,l,p) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.start_idx.train=0 datamodule.num_samples.train=2000 datamodule.start_idx.valid=2000 datamodule.num_samples.valid=500 datamodule.start_idx.test=2500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=5 datamodule.data_dir="/home/usr/output/2/xyclp/" datamodule.dataset.properties_list=["x","y","c","l","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=2000 ckpt_path=null

# training from scratch (x,y,c,s,l,p) (cube only)
# python3 run_training.py model=inertia_balls_slot_attention_ae datamodule=sparse_clevr datamodule.start_idx.train=0 datamodule.num_samples.train=2000 datamodule.start_idx.valid=2000 datamodule.num_samples.valid=500 datamodule.start_idx.test=2500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=6 datamodule.data_dir="/home/usr/output/2/all_p/" datamodule.dataset.properties_list=["x","y","c","s","l","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.additional_logger.logging_interval=400 callbacks=vanilla_slot_attention ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["vanilla_SA","clevr"] trainer.max_epochs=4000 ckpt_path=null

# ---------- Disentanglement ---------- #
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/special/" datamodule.start_idx.train=0 datamodule.num_samples.train=9000 datamodule.start_idx.valid=9000 datamodule.num_samples.valid=500 datamodule.start_idx.test=9500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=5 datamodule.dataset.properties_list=["x","y","c","s","l"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=5 model.disentangle_z_dim=5 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=2000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (c, grayscale) (sphere only) (fixed position) (3 colours)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/c_grayscale/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=300 datamodule.start_idx.valid=300 datamodule.num_samples.valid=100 datamodule.start_idx.test=400 datamodule.num_samples.test=100 datamodule.dataset.z_dim=1 datamodule.dataset.properties_list=["c"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=1 model.disentangle_z_dim=1 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=40 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (c, coloured) (sphere only) (fixed position) (3 colours)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/c_coloured/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=300 datamodule.start_idx.valid=300 datamodule.num_samples.valid=100 datamodule.start_idx.test=400 datamodule.num_samples.test=100 datamodule.dataset.z_dim=1 datamodule.dataset.properties_list=["c"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=1 model.disentangle_z_dim=1 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=40 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (shape) (fixed position) (3 colours)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/s/" datamodule.start_idx.train=0 datamodule.num_samples.train=300 datamodule.start_idx.valid=300 datamodule.num_samples.valid=100 datamodule.start_idx.test=400 datamodule.num_samples.test=100 datamodule.dataset.z_dim=1 datamodule.dataset.properties_list=["s"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=1 model.disentangle_z_dim=1 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=40 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (x,y,c) (cube only) (3 colours)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyc/cube" datamodule.start_idx.train=0 datamodule.num_samples.train=1000 datamodule.start_idx.valid=1000 datamodule.num_samples.valid=500 datamodule.start_idx.test=1500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","c"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=3 model.disentangle_z_dim=3 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyc/cube" datamodule.start_idx.train=0 datamodule.num_samples.train=1000 datamodule.start_idx.valid=1000 datamodule.num_samples.valid=500 datamodule.start_idx.test=1500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","c"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=3 model.disentangle_z_dim=3 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=True model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (x,y,c) (sphere only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyc/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=1000 datamodule.start_idx.valid=1000 datamodule.num_samples.valid=500 datamodule.start_idx.test=1500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","c"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=3 model.disentangle_z_dim=3 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (x,y,l) (cube only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyl/cube" datamodule.start_idx.train=0 datamodule.num_samples.train=1000 datamodule.start_idx.valid=1000 datamodule.num_samples.valid=500 datamodule.start_idx.test=1500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","l"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=3 model.disentangle_z_dim=3 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# training from scratch (x,y,l) (sphere only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyl/sphere" datamodule.start_idx.train=0 datamodule.num_samples.train=1000 datamodule.start_idx.valid=1000 datamodule.num_samples.valid=500 datamodule.start_idx.test=1500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=3 datamodule.dataset.properties_list=["x","y","l"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=3 model.disentangle_z_dim=3 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=4000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# x,y,c,p (cube only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xycp/" datamodule.start_idx.train=0 datamodule.num_samples.train=3000 datamodule.start_idx.valid=3000 datamodule.num_samples.valid=500 datamodule.start_idx.test=3500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=4 datamodule.dataset.properties_list=["x","y","c","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=4 model.disentangle_z_dim=4 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=2000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# x,y,s,p
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xysp/" datamodule.start_idx.train=0 datamodule.num_samples.train=3000 datamodule.start_idx.valid=3000 datamodule.num_samples.valid=500 datamodule.start_idx.test=3500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=4 datamodule.dataset.properties_list=["x","y","s","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=4 model.disentangle_z_dim=4 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=2000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# x,y,c,l,p (cube only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/xyclp/" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=5 datamodule.dataset.properties_list=["x","y","c","l","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=5 model.disentangle_z_dim=5 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=2000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"

# x,y,c,s,l,p (all_p) (cube only)
# python3 run_training.py model=inertia_balls_saae_contrastive_recons datamodule=sparse_clevr datamodule.data_dir="/home/usr/output/2/all_p/" datamodule.start_idx.train=0 datamodule.num_samples.train=4000 datamodule.start_idx.valid=4000 datamodule.num_samples.valid=500 datamodule.start_idx.test=4500 datamodule.num_samples.test=500 datamodule.dataset.z_dim=6 datamodule.dataset.properties_list=["x","y","c","s","l","p"] datamodule.n_balls=2 datamodule.batch_size=256 model.z_dim=6 model.disentangle_z_dim=6 model.encoder.slot_size=64 model.encoder.n_channels=4 model.optimizer.lr=0.0002 model.w_recons_loss=100.0 model.w_latent_loss=10.0 model.wait_steps=0 model.linear_steps=1 model.latent_matching="argmin" model.ball_matching=False model.double_matching=False model.known_mechanism=True model.known_action=True model.use_all_balls_mcc=False model.rm_background_in_matching=True model.pair_recons=True model.encoder_freeze=False model.additional_logger.logging_interval=400 callbacks=default ~model/scheduler_config ~callbacks.visualization_callback ~callbacks.early_stopping callbacks.model_checkpoint.monitor="train_loss" logger.wandb.tags=["disentanglement","no_matching","clevr"] trainer.max_epochs=2000 ckpt_path=null model.pl_model_ckpt_path="path/to/ckpt.ckpt"


deactivate
module purge
