#Reverse Knowledge Distillation
+ Reversing Structural Pattern Learning with Biologically Inspired Knowledge Distillation for Spiking Neural Networks
+ Framework: Spikingjelly, Pytorch
+ Dataset: CIFAR100，DVSgesture, Imagenet

##Dependency
+ We use a framework for building spiking neural network called Spikingjelly which is based on Pytorch.
+ Install Pytorch = 1.10.1+cuda10.2:
	```
	conda install pytorch torchvision torchaudio cudatoolkit=10.2 -c pytorch
	```
+ Install Spikingjelly from GitHub:

	```
	git clone https://github.com/fangwei123456/spikingjelly.git
	cd spikingjelly
    git checkout 0.0.0.0.12
	python setup.py install
	```

##Install
+ Install the dependencies:
	```
	pip install -r requirements.txt
	```

##Organization
- ./re-KD/sparse-KD: the knowledge distillation based sparse-KD method 
	- ./cifar100: training on the cifar100 dataset
	- ./DVSgesture: training on the DVSgesture dataset
- ./re-KD/default-KD: the knowledge distillation based default-KD method
    - ./cifar100: training on the cifar100 dataset
	- ./DVSgesture: training on the DVSgesture dataset

##Running Examples
###sparse-KD method
+ Train on CIFAR100
	```
	cd /sparse-KD/cifar100
	```
	```
	#Train a SNNWideResNet16-4 
	python trainsnn.py --model_version snnwrn16-4 --learning_rate 0.05
	#Prune the model
	python cifar100_prune.py
	#Train a SNNWideResNet16-4 with sparse-KD
	python trainkdsnnsparse.py --model_version snn_wrn16-4_distill  --teacher snnwrn16-4 --learning_rate 0.3 --temperature 6 --alpha 0.95
	```
    ```
	#Train a snnresnet18 
	python trainsnn.py --model_version snnresnet18 --learning_rate 0.01
	#Prune the model
	python cifar100_prune.py
	#Train a snnresnet18 with sparse-KD
	python trainkdsnnsparse.py --model_version snn_resnet18_distill  --teacher snnresnet18 --learning_rate 0.3 --temperature 6 --alpha 0.95
	```
+ Train on Imagenet
	```
	cd /sparse-KD/Imagenet
	```
	```
	#Train a snnresnet18 
	python trainkdsnnimg.py --model_version snnresnet18 --learning_rate 0.003
	#Prune the model
	python cifar100_prune.py
	#Train a snnresnet18 with sparse-KD
	python trainkdsnnimgkd.py --model_version snn_resnet18_distill  --teacher snnresnet18 --learning_rate 0.0003 --temperature 6 --alpha 0.95
	```
+ Train on DVSgesture
	```
	cd /sparse-KD/DVSgesture
    ```
	```
	#Train a 5Conv 1FC net 
	python trainnetdvs.py.py --model_version net --learning_rate 3e-3
	#Prune the model
	python net_prune.py
	#Train a 5Conv 1FC net with sparse-KD
	python trainnetdvskd.py.py --model_version snn_net_distill  --teacher net --learning_rate 1e-3 --temperature 6 --alpha 0.5
	```

###default-KD method
+ Train on CIFAR100
	```
	cd /default-KD/cifar100
	```
	```
	#Train a SNNWideResNet16-4 
	python trainsnn.py --model_version snnwrn16-4 --learning_rate 0.05
	#Train a SNNWideResNet16-4 with sparse-KD
	python trainkdsnndefault.py --model_version snnwrn16-4 --learning_rate 0.1 --default_alpha 0.1 --T 6 --multiplier 1000
	```
    ```
	#Train a snnresnet18 
	python trainsnn.py --model_version snnresnet18 --learning_rate 0.01
	#Train a snnresnet18 with sparse-KD
	python trainkdsnndefault.py --model_version snnresnet18 --learning_rate 0.1 --default_alpha 0.1 --T 6 --multiplier 1000
	```
    ```
	#Train a snnvgg16 
	python trainsnn.py --model_version snnvgg16 --learning_rate 0.01
	#Train a snnvgg16 with sparse-KD
	python trainkdsnndefault.py --model_version snnvgg16   --learning_rate 0.01 --default_alpha 0.1 --T 6 --multiplier 100
	```
+ Train on Imagenet
	```
	cd /default-KD/Imagenet
	```
	```
	#Train a snnresnet18 
	python trainkdsnnimg.py --model_version snnresnet18 --learning_rate 0.003
	#Train a snnresnet18 with sparse-KD
	python trainkdsnnimgde.py --model_version snnresnet18 --learning_rate 0.1 --default_alpha 0.003 --T 6 --multiplier 1000
	```
+ Train on DVSgesture
	```
	cd /default-KD/DVSgesture
	```
	```
	#Train a 5Conv 1FC net 
	python trainnetdvs.py --model_version net --learning_rate 3e-3
	#Train a 5Conv 1FC net with sparse-KD
	python trainkdsnnnetdvsdefault.py --model_version net --learning_rate 1e-3 --default_alpha 0.1 --T 6 --multiplier 1000
	```
 