# nnU-Net with AdamCPR

This repo contains the AdamCPR optimizer implemented for segmentation benchmarks in the nnU-Net framework. For more information, refer to the original nnU-Net documentation (and info from next chapter onwards).

## Setting up the environment

Set up your environment and install the latest version of PyTorch with support for your hardware (cuda, mps, cpu). Then install requirements (all contained in nnU-Net v2) via:
```
pip install -r requirements.txt
```

Assuming a running environment with nnU-Net v2 installed and the (preprocessed) datasets are present in the nnU-Net format, the following environment variables have to be set:
```
export nnUNet_preprocessed=/path/to/nnUNet_preprocessed
export nnUNet_results=/path/to/experiment/results
```


With those set, a complete list of experiment commands to be run can be generated via `generate_all_AdamCPR_experiment_commands.sh` and `generate_all_AdamW_baseline_commands.sh`.

One example would be:
```
python train_nnUNet.py 2 3d_fullres 0 -tr nnUNetTrainerQuickAdamCPR -adam_cpr_mode l2_constrain_mh -adam_cpr_kappa 1.0 -adam_cpr_kappa_init_steps 2000
```

Note that these commands assume dataset IDs following nnU-Net's numbering: 
2=Dataset002_Heart, 17=Dataset017_AbdominalOrganSegmentation, 82=Dataset082_BraTS2020
If you used different dataset IDs when generating the dataset.json for nnU-Net's planning & preprocessing, adapt the IDs in the run scripts accordingly.
