import numpy as np
import os
import ssm


def sample1(data, size):
	mean = np.mean(data, axis=0)
	std = np.std(data, axis = 0)
	return np.random.normal(mean, std, (size, data.shape[1]))

def sample2(data, size):
	mean = np.mean(data, axis=0)
	cov = np.cov(data, rowvar=False)
	return np.random.multivariate_normal(mean, cov, size)

def sample3(data, size, neg=False):
	mean = np.mean(data, axis=0)
	cov = np.cov(data, rowvar=False)
	std = np.std(data, axis=0)
	if neg:
		new_mean = mean - std/2
	else:
		new_mean = mean + std/2
	new_cov = cov/3

	return np.random.multivariate_normal(new_mean, new_cov, int(size))

