import wandb
wandb.login()

sweep_config = {
    'method': 'grid'
    }
metric = {
    'name': 'val_loss',
    'goal': 'minimize'
    }

sweep_config['metric'] = metric
parameters_dict = {
    'num_layers':{
        'value': 2
    },
    'layer_dims':{
        'value': 250
    },
    'batch_size': {
        'value':  10000,
    },
    'lr': {
        'value': 1e-3
    },
    'nw':{
        'value': 0
    },
    'kl':{
        'value': 1e-5
    },
    'latent': {
        'value': 2
    },
    'time':{
        'value': False
    },
    'emg': {
        'value': False
    },
    'save_best':{
        'value': False
    },
    'seed': {
        'values': [0,1,2,3]
    }
    }

sweep_config['parameters'] = parameters_dict
parameters_dict.update({
    'epochs': {
        'value': 500},
    'data_artifact': {
        'value': 'train_subject'
    },
    })
sweep_id = wandb.sweep(sweep_config, project="neighbor_vae")
