import json
from tqdm import tqdm
from argparse import ArgumentParser

def main():
    parser = ArgumentParser()
    parser.add_argument("--input_path", type=str, default=None)
    args = parser.parse_args()

    data = []
    with open(args.input_path, 'r') as f:
       for line in f:
           data.append(json.loads(line))
    print(len(data))
    count = 0
    for item in data:
        ground_truth = []
        for i in item['Golden']:
            if i['type'] == 'text':
                ground_truth.append("<text>")
            elif i['type'] == 'image':
                ground_truth.append("<image>")
        predict = []
        if item.get('predict') and item['predict'].get('sequence') and item['predict']['sequence'].get('Answer'):
            for i in item['predict']['sequence']['Answer']:
                if "text" in i:
                    predict.append("<text>")
                elif "img" in i:
                    predict.append("<image>")
        else:
            print(item['id'], " Null")
        # calculate the absolute match  between ground_truth and predict
        if ground_truth == predict:
            count += 1
        else:
            print(item['id'], " Wrong")
    print(f"Accuracy: {count/len(data)}")
    
if __name__ == "__main__":
    main()