# Supplementary Material for Submission: Interleaved Scene Graphs for Interleaved Text-and-Image Generation

This project introduces a novel approach to interleaved text-and-image generation using Interleaved Scene Graphs. It consists of three main components:

1. Evaluation Method: Interleaved Scene Graph (ISG)
2. Benchmark: ISG-Bench
3. Agent: ISG-Agent for generating Interleaved Text-and-Image content

## Directory Structure

```
.
├── ISG/
│   └── (Evaluation method files)
├── ISG-Bench/
│   └── ISG-Bench.jsonl
└── ISG-Agent/
    └── README.md
```


## ISG-Bench

The ISG-Bench is our benchmark dataset for evaluating interleaved text-and-image generation models. It is located in the `ISG-Bench` directory.

### Dataset Details
- File: `ISG-Bench/ISG-Bench.jsonl`
- Samples: 1,150
- Categories: 8
- Subcategories: 21
- Language: English

Each sample in the dataset provides a multimodal query and a referential golden answer for evaluation. These answers are constructed using cross-validated human annotations.

Notice: Due to the limitation of file size, we condense all the images in the ISG-Bench to 224x224 resolution in the supplementary material, while the original resolution for benchmark is variable.

## Evaluation

To evaluate your model's performance:

1. Generate interleaved text and image content for each sample in the benchmark.
2. Place the generated content under the `output` key of each sample.
3. Run the evaluation script:

```
python judge_model_performance.py --input_file <your_file_name> --GT_file ../ISG-Bench/ISG-Bench.jsonl --root ../ISG-Bench --start 0
```

**Note:** Before running the evaluation, make sure to input your API KEY in `ISG/vqa_model.py`.

## ISG-Agent

For details on the agent for generating Interleaved Text-and-Image content that strictly follows user instructions, please refer to `ISG-Agent/README.md`.

## License

This benchmark is released under the Apache License 2.0.

For more information or if you have any questions, please refer to the individual README files in each directory or open an issue in this repository.