import os
import json
import shutil
from warnings import warn

def get_run_name(dataset_ls):
    run_name = ''
    for task in dataset_ls:
        run_name += '{}-'.format(task)
    run_name = run_name[:-1]
    return run_name

def ensure_path(path, remove=True):
  basename = os.path.basename(path.rstrip('/'))
  if os.path.exists(path):
    if remove and (basename.startswith('_')
      or input('{} exists, remove? ([y]/n): '.format(path)) != 'n'):
      shutil.rmtree(path)
      os.makedirs(path)
  else:
    os.makedirs(path)