import torch

models = {} # the table to save all types of network

def register(name):
    def decorator(cls):
        models[name] = cls
        return cls

    return decorator

def make(device, name, **kwargs):
    '''
    to construte the encoder
    Args:
        name(str): the type of encoder
        **kwarge(**list): the address of the kwargs list
    
    Returns:
        return the constructed encoder
    '''
    
    if name is None:
        return None
    
    model = models[name](**kwargs)
    model.to(device)

    return model